/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.JdkVersion;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEventMulticaster;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEventMulticasterAdapter;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.osgi.extender.OsgiApplicationContextCreator;
import org.springframework.osgi.extender.OsgiBeanFactoryPostProcessor;
import org.springframework.osgi.extender.OsgiServiceDependencyFactory;
import org.springframework.osgi.extender.internal.dependencies.startup.MandatoryImporterDependencyFactory;
import org.springframework.osgi.extender.internal.support.DefaultOsgiBundleApplicationContextListener;
import org.springframework.osgi.extender.internal.support.OsgiAnnotationPostProcessor;
import org.springframework.osgi.extender.support.DefaultOsgiApplicationContextCreator;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.scheduling.timer.TimerTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ExtenderConfiguration
implements DisposableBean {
    private static final Log log = LogFactory.getLog(ExtenderConfiguration.class);
    private static final String TASK_EXECUTOR_NAME = "taskExecutor";
    private static final String SHUTDOWN_TASK_EXECUTOR_NAME = "shutdownTaskExecutor";
    private static final String CONTEXT_CREATOR_NAME = "applicationContextCreator";
    private static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "osgiApplicationEventMulticaster";
    private static final String CONTEXT_LISTENER_NAME = "osgiApplicationContextListener";
    private static final String PROPERTIES_NAME = "extenderProperties";
    private static final String SHUTDOWN_WAIT_KEY = "shutdown.wait.time";
    private static final String PROCESS_ANNOTATIONS_KEY = "process.annotations";
    private static final String WAIT_FOR_DEPS_TIMEOUT_KEY = "dependencies.wait.time";
    private static final String EXTENDER_CFG_LOCATION = "META-INF/spring/extender";
    private static final String XML_PATTERN = "*.xml";
    private static final String ANNOTATION_DEPENDENCY_FACTORY = "org.springframework.osgi.extensions.annotation.ServiceReferenceDependencyBeanFactoryPostProcessor";
    private static final String AUTO_ANNOTATION_PROCESSING = "org.springframework.osgi.extender.annotation.auto.processing";
    private static final long DEFAULT_DEP_WAIT = 300000L;
    private static final long DEFAULT_SHUTDOWN_WAIT = 10000L;
    private static final boolean DEFAULT_PROCESS_ANNOTATION = false;
    private ConfigurableOsgiBundleApplicationContext extenderConfiguration;
    private TaskExecutor taskExecutor;
    private TaskExecutor shutdownTaskExecutor;
    private boolean isTaskExecutorManagedInternally;
    private boolean isShutdownTaskExecutorManagedInternally;
    private boolean isMulticasterManagedInternally;
    private long shutdownWaitTime;
    private long dependencyWaitTime;
    private boolean processAnnotation;
    private OsgiBundleApplicationContextEventMulticaster eventMulticaster;
    private OsgiBundleApplicationContextListener contextEventListener;
    private boolean forceThreadShutdown;
    private OsgiApplicationContextCreator contextCreator;
    private final ClassLoader classLoader;
    private final List postProcessors = Collections.synchronizedList(new ArrayList(0));
    private final List dependencyFactories = Collections.synchronizedList(new ArrayList(0));
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtenderConfiguration(BundleContext bundleContext) {
        Object object;
        Bundle bundle = bundleContext.getBundle();
        Properties properties = new Properties(this.createDefaultProperties());
        Enumeration enm = bundle.findEntries(EXTENDER_CFG_LOCATION, XML_PATTERN, false);
        if (enm == null) {
            log.info("No custom extender configuration detected; using defaults...");
            object = this.lock;
            synchronized (object) {
                this.taskExecutor = this.createDefaultTaskExecutor();
                this.shutdownTaskExecutor = this.createDefaultShutdownTaskExecutor();
                this.eventMulticaster = this.createDefaultEventMulticaster();
                this.contextCreator = this.createDefaultApplicationContextCreator();
                this.contextEventListener = this.createDefaultApplicationContextListener();
            }
            this.classLoader = BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle);
        } else {
            Object[] configs = this.copyEnumerationToList(enm);
            log.info("Detected extender custom configurations at " + ObjectUtils.nullSafeToString(configs));
            OsgiBundleXmlApplicationContext extenderAppCtx = new OsgiBundleXmlApplicationContext((String[])configs);
            extenderAppCtx.setBundleContext(bundleContext);
            extenderAppCtx.refresh();
            Object object2 = this.lock;
            synchronized (object2) {
                this.extenderConfiguration = extenderAppCtx;
                TaskExecutor taskExecutor = this.extenderConfiguration.containsBean(TASK_EXECUTOR_NAME) ? (TaskExecutor)this.extenderConfiguration.getBean(TASK_EXECUTOR_NAME, TaskExecutor.class) : (this.taskExecutor = this.createDefaultTaskExecutor());
                TaskExecutor taskExecutor2 = this.extenderConfiguration.containsBean(SHUTDOWN_TASK_EXECUTOR_NAME) ? (TaskExecutor)this.extenderConfiguration.getBean(SHUTDOWN_TASK_EXECUTOR_NAME, TaskExecutor.class) : (this.shutdownTaskExecutor = this.createDefaultShutdownTaskExecutor());
                OsgiBundleApplicationContextEventMulticaster osgiBundleApplicationContextEventMulticaster = this.extenderConfiguration.containsBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME) ? (OsgiBundleApplicationContextEventMulticaster)this.extenderConfiguration.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, OsgiBundleApplicationContextEventMulticaster.class) : (this.eventMulticaster = this.createDefaultEventMulticaster());
                OsgiApplicationContextCreator osgiApplicationContextCreator = this.extenderConfiguration.containsBean(CONTEXT_CREATOR_NAME) ? (OsgiApplicationContextCreator)this.extenderConfiguration.getBean(CONTEXT_CREATOR_NAME, OsgiApplicationContextCreator.class) : (this.contextCreator = this.createDefaultApplicationContextCreator());
                this.contextEventListener = this.extenderConfiguration.containsBean(CONTEXT_LISTENER_NAME) ? (OsgiBundleApplicationContextListener)this.extenderConfiguration.getBean(CONTEXT_LISTENER_NAME, OsgiBundleApplicationContextListener.class) : this.createDefaultApplicationContextListener();
            }
            this.postProcessors.addAll(this.extenderConfiguration.getBeansOfType(OsgiBeanFactoryPostProcessor.class).values());
            this.dependencyFactories.addAll(this.extenderConfiguration.getBeansOfType(OsgiServiceDependencyFactory.class).values());
            this.classLoader = this.extenderConfiguration.getClassLoader();
            if (this.extenderConfiguration.containsBean(PROPERTIES_NAME)) {
                Properties customProperties = (Properties)this.extenderConfiguration.getBean(PROPERTIES_NAME, Properties.class);
                Enumeration<?> propertyKey = customProperties.propertyNames();
                while (propertyKey.hasMoreElements()) {
                    String property2 = (String)propertyKey.nextElement();
                    properties.setProperty(property2, customProperties.getProperty(property2));
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.shutdownWaitTime = this.getShutdownWaitTime(properties);
            this.dependencyWaitTime = this.getDependencyWaitTime(properties);
            this.processAnnotation = this.getProcessAnnotations(properties);
        }
        this.addDefaultDependencyFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMulticasterManagedInternally) {
                this.eventMulticaster.removeAllListeners();
                this.eventMulticaster = null;
            }
            if (this.extenderConfiguration != null) {
                this.extenderConfiguration.close();
                this.extenderConfiguration = null;
            }
            if (this.forceThreadShutdown) {
                if (this.isTaskExecutorManagedInternally) {
                    log.warn("Forcing the (internally created) taskExecutor to stop...");
                    ThreadGroup th = ((SimpleAsyncTaskExecutor)this.taskExecutor).getThreadGroup();
                    if (!th.isDestroyed()) {
                        th.interrupt();
                    }
                }
                this.taskExecutor = null;
            }
            if (this.isShutdownTaskExecutorManagedInternally) {
                try {
                    ((DisposableBean)((Object)this.shutdownTaskExecutor)).destroy();
                }
                catch (Exception ex) {
                    log.debug("Received exception while shutting down shutdown task executor", ex);
                }
                this.shutdownTaskExecutor = null;
            }
        }
    }

    private String[] copyEnumerationToList(Enumeration enm) {
        ArrayList<String> urls = new ArrayList<String>(4);
        while (enm != null && enm.hasMoreElements()) {
            URL configURL = (URL)enm.nextElement();
            if (configURL == null) continue;
            String configURLAsString = configURL.toExternalForm();
            try {
                urls.add(URLDecoder.decode(configURLAsString, "UTF8"));
            }
            catch (UnsupportedEncodingException uee) {
                log.warn("UTF8 encoding not supported, using the platform default");
                urls.add(URLDecoder.decode(configURLAsString));
            }
        }
        return urls.toArray(new String[urls.size()]);
    }

    private Properties createDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty(SHUTDOWN_WAIT_KEY, "10000");
        properties.setProperty(PROCESS_ANNOTATIONS_KEY, "false");
        properties.setProperty(WAIT_FOR_DEPS_TIMEOUT_KEY, "300000");
        return properties;
    }

    private void addDefaultDependencyFactories() {
        boolean debug = log.isDebugEnabled();
        this.dependencyFactories.add(0, new MandatoryImporterDependencyFactory());
        if (this.processAnnotation) {
            if (JdkVersion.isAtLeastJava15()) {
                Class<?> annotationProcessor = null;
                try {
                    annotationProcessor = Class.forName(ANNOTATION_DEPENDENCY_FACTORY, false, ExtenderConfiguration.class.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    log.warn("Spring DM annotation package not found, annotation processing disabled.", cnfe);
                    return;
                }
                Object processor = BeanUtils.instantiateClass(annotationProcessor);
                Assert.isInstanceOf(OsgiServiceDependencyFactory.class, processor);
                this.dependencyFactories.add(1, (OsgiServiceDependencyFactory)processor);
                if (debug) {
                    log.debug("Succesfully loaded annotation dependency processor [org.springframework.osgi.extensions.annotation.ServiceReferenceDependencyBeanFactoryPostProcessor]");
                }
                this.postProcessors.add(0, new OsgiAnnotationPostProcessor());
                log.info("Spring-DM annotation processing enabled");
            } else {
                if (debug) {
                    log.debug("JDK 5 not available [org.springframework.osgi.extensions.annotation.ServiceReferenceDependencyBeanFactoryPostProcessor] not loaded");
                }
                log.warn("Spring-DM annotation processing enabled but JDK 5 is n/a; disabling annotation processing...");
            }
        } else if (debug) {
            log.debug("Spring-DM annotation processing disabled; [org.springframework.osgi.extensions.annotation.ServiceReferenceDependencyBeanFactoryPostProcessor] not loaded");
        }
    }

    private TaskExecutor createDefaultTaskExecutor() {
        ThreadGroup threadGroup = new ThreadGroup("spring-osgi-extender[" + ObjectUtils.getIdentityHexString(this) + "]-threads");
        threadGroup.setDaemon(false);
        SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
        taskExecutor.setThreadGroup(threadGroup);
        taskExecutor.setThreadNamePrefix("SpringOsgiExtenderThread-");
        this.isTaskExecutorManagedInternally = true;
        return taskExecutor;
    }

    private TaskExecutor createDefaultShutdownTaskExecutor() {
        TimerTaskExecutor taskExecutor = new TimerTaskExecutor();
        taskExecutor.afterPropertiesSet();
        this.isShutdownTaskExecutorManagedInternally = true;
        return taskExecutor;
    }

    private OsgiBundleApplicationContextEventMulticaster createDefaultEventMulticaster() {
        this.isMulticasterManagedInternally = true;
        return new OsgiBundleApplicationContextEventMulticasterAdapter(new SimpleApplicationEventMulticaster());
    }

    private OsgiApplicationContextCreator createDefaultApplicationContextCreator() {
        return new DefaultOsgiApplicationContextCreator();
    }

    private OsgiBundleApplicationContextListener createDefaultApplicationContextListener() {
        return new DefaultOsgiBundleApplicationContextListener();
    }

    private long getShutdownWaitTime(Properties properties) {
        return Long.parseLong(properties.getProperty(SHUTDOWN_WAIT_KEY));
    }

    private long getDependencyWaitTime(Properties properties) {
        return Long.parseLong(properties.getProperty(WAIT_FOR_DEPS_TIMEOUT_KEY));
    }

    private boolean getProcessAnnotations(Properties properties) {
        return Boolean.valueOf(properties.getProperty(PROCESS_ANNOTATIONS_KEY)) != false || Boolean.getBoolean(AUTO_ANNOTATION_PROCESSING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor getTaskExecutor() {
        Object object = this.lock;
        synchronized (object) {
            return this.taskExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor getShutdownTaskExecutor() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdownTaskExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsgiBundleApplicationContextListener getContextEventListener() {
        Object object = this.lock;
        synchronized (object) {
            return this.contextEventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getShutdownWaitTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdownWaitTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldProcessAnnotation() {
        Object object = this.lock;
        synchronized (object) {
            return this.processAnnotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDependencyWaitTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.dependencyWaitTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsgiBundleApplicationContextEventMulticaster getEventMulticaster() {
        Object object = this.lock;
        synchronized (object) {
            return this.eventMulticaster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceThreadShutdown(boolean forceThreadShutdown) {
        Object object = this.lock;
        synchronized (object) {
            this.forceThreadShutdown = forceThreadShutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsgiApplicationContextCreator getContextCreator() {
        Object object = this.lock;
        synchronized (object) {
            return this.contextCreator;
        }
    }

    public List getPostProcessors() {
        return this.postProcessors;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List getDependencyFactories() {
        return this.dependencyFactories;
    }
}

