/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.osgi.extender.internal.support.NamespacePlugins;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;

public class NamespaceManager
implements InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(NamespaceManager.class);
    private static final String NS_HANDLER_RESOLVER_CLASS_NAME = NamespaceHandlerResolver.class.getName();
    private NamespacePlugins namespacePlugins;
    private ServiceRegistration nsResolverRegistration;
    private ServiceRegistration enResolverRegistration = null;
    private final BundleContext context;
    private final String extenderInfo;
    private static final String META_INF = "META-INF/";
    private static final String SPRING_HANDLERS = "spring.handlers";
    private static final String SPRING_SCHEMAS = "spring.schemas";

    public NamespaceManager(BundleContext context) {
        this.context = context;
        this.extenderInfo = context.getBundle().getSymbolicName() + "|" + OsgiBundleUtils.getBundleVersion(context.getBundle());
        this.namespacePlugins = new NamespacePlugins();
    }

    public void maybeAddNamespaceHandlerFor(Bundle bundle) {
        boolean hasSchemas;
        if (OsgiBundleUtils.isSystemBundle(bundle)) {
            return;
        }
        boolean hasHandlers = bundle.findEntries(META_INF, SPRING_HANDLERS, false) != null;
        boolean bl = hasSchemas = bundle.findEntries(META_INF, SPRING_SCHEMAS, false) != null;
        if (hasHandlers) {
            if (this.hasCompatibleNamespaceType(bundle)) {
                this.addHandler(bundle);
            } else if (log.isDebugEnabled()) {
                log.debug("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName(bundle) + "] declares namespace handlers but is not compatible with extender [" + this.extenderInfo + "]; ignoring...");
            }
        } else if (hasSchemas) {
            this.addHandler(bundle);
        }
    }

    private boolean hasCompatibleNamespaceType(Bundle bundle) {
        try {
            Class type = bundle.loadClass(NS_HANDLER_RESOLVER_CLASS_NAME);
            return NamespaceHandlerResolver.class.equals(type);
        }
        catch (Throwable th) {
            log.warn("Bundle " + OsgiStringUtils.nullSafeNameAndSymName(bundle) + " cannot see class [" + NS_HANDLER_RESOLVER_CLASS_NAME + "]; ignoring its namespace handlers");
            return false;
        }
    }

    protected void addHandler(Bundle bundle) {
        Assert.notNull(bundle);
        if (log.isDebugEnabled()) {
            log.debug("Adding namespace handler resolver for " + OsgiStringUtils.nullSafeNameAndSymName(bundle));
        }
        this.namespacePlugins.addHandler(bundle);
    }

    public void maybeRemoveNameSpaceHandlerFor(Bundle bundle) {
        Assert.notNull(bundle);
        boolean removed = this.namespacePlugins.removeHandler(bundle);
        if (removed && log.isDebugEnabled()) {
            log.debug("Removed namespace handler resolver for " + OsgiStringUtils.nullSafeNameAndSymName(bundle));
        }
    }

    private void registerResolverServices() {
        if (log.isDebugEnabled()) {
            log.debug("Registering Spring NamespaceHandlerResolver and EntityResolver...");
        }
        this.nsResolverRegistration = this.context.registerService(new String[]{NamespaceHandlerResolver.class.getName()}, (Object)this.namespacePlugins, null);
        this.enResolverRegistration = this.context.registerService(new String[]{EntityResolver.class.getName()}, (Object)this.namespacePlugins, null);
    }

    private void unregisterResolverService() {
        boolean result = OsgiServiceUtils.unregisterService(this.nsResolverRegistration);
        boolean bl = result = result || OsgiServiceUtils.unregisterService(this.enResolverRegistration);
        if (result && log.isDebugEnabled()) {
            log.debug("Unregistering Spring NamespaceHandler and EntityResolver service");
        }
        this.nsResolverRegistration = null;
        this.enResolverRegistration = null;
    }

    public NamespacePlugins getNamespacePlugins() {
        return this.namespacePlugins;
    }

    public void afterPropertiesSet() {
        this.registerResolverServices();
    }

    public void destroy() {
        this.unregisterResolverService();
        this.namespacePlugins.destroy();
        this.namespacePlugins = null;
    }
}

