/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.core.CollectionFactory;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.osgi.util.OsgiStringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NamespacePlugins
implements NamespaceHandlerResolver,
EntityResolver,
DisposableBean {
    private static final Log log = LogFactory.getLog(NamespacePlugins.class);
    private final Map plugins = CollectionFactory.createConcurrentMap(5);

    public void addHandler(Bundle bundle) {
        if (log.isDebugEnabled()) {
            log.debug("Adding as handler " + OsgiStringUtils.nullSafeNameAndSymName(bundle));
        }
        this.plugins.put(bundle, new Plugin(bundle));
    }

    public boolean removeHandler(Bundle bundle) {
        if (log.isDebugEnabled()) {
            log.debug("Removing handler " + OsgiStringUtils.nullSafeNameAndSymName(bundle));
        }
        return this.plugins.remove(bundle) != null;
    }

    public NamespaceHandler resolve(final String namespaceUri) {
        if (System.getSecurityManager() != null) {
            return (NamespaceHandler)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return NamespacePlugins.this.doResolve(namespaceUri);
                }
            });
        }
        return this.doResolve(namespaceUri);
    }

    public InputSource resolveEntity(final String publicId, final String systemId) throws SAXException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                return (InputSource)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return NamespacePlugins.this.doResolveEntity(publicId, systemId);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception cause = pae.getException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw (SAXException)cause;
            }
        }
        return this.doResolveEntity(publicId, systemId);
    }

    private NamespaceHandler doResolve(String namespaceUri) {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("Trying to resolving namespace handler for " + namespaceUri);
        }
        Iterator i = this.plugins.values().iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            try {
                NamespaceHandler handler = plugin.resolve(namespaceUri);
                if (handler == null) continue;
                if (debug) {
                    log.debug("Namespace handler for " + namespaceUri + " found inside " + OsgiStringUtils.nullSafeNameAndSymName(plugin.getBundle()));
                }
                return handler;
            }
            catch (IllegalArgumentException ex) {
                if (!debug) continue;
                log.debug("Namespace handler for " + namespaceUri + " not found inside " + OsgiStringUtils.nullSafeNameAndSymName(plugin.getBundle()));
            }
        }
        return null;
    }

    private InputSource doResolveEntity(String publicId, String systemId) throws SAXException, IOException {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("Trying to resolving entity for " + publicId + "|" + systemId);
        }
        if (systemId != null) {
            Iterator i = this.plugins.values().iterator();
            while (i.hasNext()) {
                Plugin plugin = (Plugin)i.next();
                try {
                    InputSource inputSource = plugin.resolveEntity(publicId, systemId);
                    if (inputSource == null) continue;
                    if (debug) {
                        log.debug("XML schema for " + publicId + "|" + systemId + " found inside " + OsgiStringUtils.nullSafeNameAndSymName(plugin.getBundle()));
                    }
                    return inputSource;
                }
                catch (FileNotFoundException ex) {
                    if (!debug) continue;
                    log.debug("XML schema for " + publicId + "|" + systemId + " not found inside " + OsgiStringUtils.nullSafeNameAndSymName(plugin.getBundle()), ex);
                }
            }
        }
        return null;
    }

    public void destroy() {
        this.plugins.clear();
    }

    private static class Plugin
    implements NamespaceHandlerResolver,
    EntityResolver {
        private final NamespaceHandlerResolver namespace;
        private final EntityResolver entity;
        private final Bundle bundle;

        private Plugin(Bundle bundle) {
            this.bundle = bundle;
            BundleDelegatingClassLoader loader = BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle);
            this.entity = new DelegatingEntityResolver(loader);
            this.namespace = new DefaultNamespaceHandlerResolver(loader);
        }

        public NamespaceHandler resolve(String namespaceUri) {
            return this.namespace.resolve(namespaceUri);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return this.entity.resolveEntity(publicId, systemId);
        }

        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

