/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.support;

import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.osgi.extender.support.internal.ConfigUtils;
import org.springframework.osgi.extender.support.scanning.ConfigurationScanner;
import org.springframework.osgi.extender.support.scanning.DefaultConfigurationScanner;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ApplicationContextConfiguration {
    private static final Log log = LogFactory.getLog(ApplicationContextConfiguration.class);
    private final Bundle bundle;
    private final ConfigurationScanner configurationScanner;
    private final boolean asyncCreation;
    private final String[] configurationLocations;
    private final boolean isSpringPoweredBundle;
    private final boolean publishContextAsService;
    private final boolean waitForDeps;
    private final String toString;
    private final long timeout;

    public ApplicationContextConfiguration(Bundle bundle) {
        this(bundle, new DefaultConfigurationScanner());
    }

    public ApplicationContextConfiguration(Bundle bundle, ConfigurationScanner configurationScanner) {
        Assert.notNull(bundle);
        Assert.notNull(configurationScanner);
        this.bundle = bundle;
        this.configurationScanner = configurationScanner;
        Dictionary headers = this.bundle.getHeaders();
        Object[] configs = this.configurationScanner.getConfigurations(bundle);
        this.isSpringPoweredBundle = !ObjectUtils.isEmpty(configs);
        this.configurationLocations = configs;
        long option = ConfigUtils.getTimeOut(headers);
        this.timeout = option >= 0L ? option * 1000L : option;
        this.publishContextAsService = ConfigUtils.getPublishContext(headers);
        this.asyncCreation = ConfigUtils.getCreateAsync(headers);
        this.waitForDeps = ConfigUtils.getWaitForDependencies(headers);
        StringBuffer buf = new StringBuffer();
        buf.append("AppCtxCfg [Bundle=");
        buf.append(OsgiStringUtils.nullSafeSymbolicName(bundle));
        buf.append("]isSpringBundle=");
        buf.append(this.isSpringPoweredBundle);
        buf.append("|async=");
        buf.append(this.asyncCreation);
        buf.append("|wait-for-deps=");
        buf.append(this.waitForDeps);
        buf.append("|publishCtx=");
        buf.append(this.publishContextAsService);
        buf.append("|timeout=");
        buf.append(this.timeout / 1000L);
        buf.append("s");
        this.toString = buf.toString();
        if (log.isTraceEnabled()) {
            log.trace("Configuration: " + this.toString);
        }
    }

    public boolean isSpringPoweredBundle() {
        return this.isSpringPoweredBundle;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isCreateAsynchronously() {
        return this.asyncCreation;
    }

    public boolean isPublishContextAsService() {
        return this.publishContextAsService;
    }

    public boolean isWaitForDependencies() {
        return this.waitForDeps;
    }

    public String[] getConfigurationLocations() {
        return this.configurationLocations;
    }

    public String toString() {
        return this.toString;
    }
}

