/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.support;

import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.extender.OsgiApplicationContextCreator;
import org.springframework.osgi.extender.support.DefaultOsgiApplicationContextCreator;
import org.springframework.util.Assert;

public class ConditionalApplicationContextCreator
implements OsgiApplicationContextCreator,
InitializingBean {
    private BundleContextFilter filter;
    private OsgiApplicationContextCreator delegatedContextCreator;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.filter, "filter property is required");
        if (this.delegatedContextCreator == null) {
            this.delegatedContextCreator = new DefaultOsgiApplicationContextCreator();
        }
    }

    public DelegatedExecutionOsgiBundleApplicationContext createApplicationContext(BundleContext bundleContext) throws Exception {
        if (this.filter.matches(bundleContext)) {
            return this.delegatedContextCreator.createApplicationContext(bundleContext);
        }
        return null;
    }

    public void setFilter(BundleContextFilter filter) {
        this.filter = filter;
    }

    public void setDelegatedApplicationContextCreator(OsgiApplicationContextCreator delegatedContextCreator) {
        this.delegatedContextCreator = delegatedContextCreator;
    }

    public static interface BundleContextFilter {
        public boolean matches(BundleContext var1);
    }
}

