/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support;

import java.util.Map;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.service.exporter.OsgiServicePropertiesResolver;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanNameServicePropertiesResolver
implements OsgiServicePropertiesResolver,
BundleContextAware,
InitializingBean {
    private BundleContext bundleContext;

    public Map getServiceProperties(String beanName) {
        String version;
        MapBasedDictionary p = new MapBasedDictionary();
        p.put("org.springframework.osgi.bean.name", beanName);
        String name = this.getSymbolicName();
        if (StringUtils.hasLength(name)) {
            p.put("Bundle-SymbolicName", name);
        }
        if (StringUtils.hasLength(version = this.getBundleVersion())) {
            p.put("Bundle-Version", version);
        }
        return p;
    }

    private String getBundleVersion() {
        return (String)this.bundleContext.getBundle().getHeaders().get("Bundle-Version");
    }

    private String getSymbolicName() {
        return this.bundleContext.getBundle().getSymbolicName();
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.bundleContext, "required property bundleContext has not been set");
    }
}

