/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.springframework.osgi.service.importer.support.AbstractServiceImporterProxyFactoryBean;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.CollectionType;
import org.springframework.osgi.service.importer.support.DisposableBeanRunnableAdapter;
import org.springframework.osgi.service.importer.support.StaticServiceProxyCreator;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceProxyCreator;
import org.springframework.osgi.service.importer.support.internal.collection.CollectionProxy;
import org.springframework.osgi.service.importer.support.internal.collection.OsgiServiceCollection;
import org.springframework.osgi.service.importer.support.internal.collection.OsgiServiceList;
import org.springframework.osgi.service.importer.support.internal.collection.OsgiServiceSet;
import org.springframework.osgi.service.importer.support.internal.collection.OsgiServiceSortedList;
import org.springframework.osgi.service.importer.support.internal.collection.OsgiServiceSortedSet;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterController;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterInternalActions;
import org.springframework.osgi.service.importer.support.internal.dependency.ImporterStateListener;
import org.springframework.util.Assert;

public final class OsgiServiceCollectionProxyFactoryBean
extends AbstractServiceImporterProxyFactoryBean {
    private static final Log log = LogFactory.getLog(OsgiServiceCollectionProxyFactoryBean.class);
    private Collection proxy;
    private CollectionProxy exposedProxy;
    private Runnable proxyDestructionCallback;
    private ServiceProxyCreator proxyCreator;
    private Comparator comparator;
    private CollectionType collectionType = CollectionType.LIST;
    private boolean greedyProxying = false;
    private final List stateListeners = Collections.synchronizedList(new ArrayList(4));
    private final ImporterInternalActions controller = new ImporterController(new Executor());

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.getCardinality() == null) {
            this.setCardinality(Cardinality.C_1__N);
        }
        this.proxyCreator = new StaticServiceProxyCreator(this.getInterfaces(), this.getAopClassLoader(), this.getBeanClassLoader(), this.getBundleContext(), this.getContextClassLoader(), this.greedyProxying);
    }

    public Class getObjectType() {
        return this.proxy != null ? this.proxy.getClass() : this.collectionType.getCollectionClass();
    }

    public Object getObject() {
        return super.getObject();
    }

    Object createProxy() {
        Collection delegate;
        OsgiServiceCollection collection;
        if (log.isDebugEnabled()) {
            log.debug("Creating a multi-value/collection proxy");
        }
        BundleContext bundleContext = this.getBundleContext();
        ClassLoader classLoader = this.getAopClassLoader();
        Filter filter = this.getUnifiedFilter();
        if (CollectionType.LIST.equals(this.collectionType)) {
            collection = this.comparator == null ? new OsgiServiceList(filter, bundleContext, classLoader, this.proxyCreator) : new OsgiServiceSortedList(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableList((List)((Object)collection));
        } else if (CollectionType.SET.equals(this.collectionType)) {
            collection = this.comparator == null ? new OsgiServiceSet(filter, bundleContext, classLoader, this.proxyCreator) : new OsgiServiceSortedSet(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableSet((Set)((Object)collection));
        } else if (CollectionType.SORTED_LIST.equals(this.collectionType)) {
            collection = new OsgiServiceSortedList(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableList((List)((Object)collection));
        } else if (CollectionType.SORTED_SET.equals(this.collectionType)) {
            collection = new OsgiServiceSortedSet(filter, bundleContext, classLoader, this.comparator, this.proxyCreator);
            delegate = Collections.unmodifiableSortedSet((SortedSet)((Object)collection));
        } else {
            throw new IllegalArgumentException("Unknown collection type:" + this.collectionType);
        }
        collection.setRequiredAtStartup(this.getCardinality().isMandatory());
        collection.setListeners(this.getListeners());
        collection.setStateListeners(this.stateListeners);
        collection.setServiceImporter(this);
        collection.setServiceImporterName(this.getBeanName());
        collection.afterPropertiesSet();
        this.proxy = delegate;
        this.exposedProxy = collection;
        this.proxyDestructionCallback = new DisposableBeanRunnableAdapter(collection);
        return delegate;
    }

    Runnable getProxyDestructionCallback() {
        return this.proxyDestructionCallback;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setCollectionType(CollectionType collectionType) {
        Assert.notNull(collectionType);
        this.collectionType = collectionType;
    }

    public void setCardinality(Cardinality cardinality) {
        Assert.notNull(cardinality);
        Assert.isTrue(cardinality.isMultiple(), "Only multiple cardinality ('X..N') accepted");
        super.setCardinality(cardinality);
    }

    public void setGreedyProxying(boolean greedyProxying) {
        this.greedyProxying = greedyProxying;
    }

    private class Executor
    implements ImporterInternalActions {
        private Executor() {
        }

        public void addStateListener(ImporterStateListener stateListener) {
            OsgiServiceCollectionProxyFactoryBean.this.stateListeners.add(stateListener);
        }

        public void removeStateListener(ImporterStateListener stateListener) {
            OsgiServiceCollectionProxyFactoryBean.this.stateListeners.remove(stateListener);
        }

        public boolean isSatisfied() {
            return OsgiServiceCollectionProxyFactoryBean.this.exposedProxy == null ? true : OsgiServiceCollectionProxyFactoryBean.this.exposedProxy.isSatisfied();
        }
    }
}

