/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.util.LinkedHashSet;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.context.internal.classloader.ClassLoaderFactory;
import org.springframework.osgi.service.importer.support.AbstractServiceProxyCreator;
import org.springframework.osgi.service.importer.support.ImportContextClassLoader;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceInvoker;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceStaticInterceptor;
import org.springframework.osgi.service.util.internal.aop.ServiceTCCLInterceptor;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.ObjectUtils;

class StaticServiceProxyCreator
extends AbstractServiceProxyCreator {
    private static final Log log = LogFactory.getLog(StaticServiceProxyCreator.class);
    private final boolean greedyProxying;
    private final boolean interfacesOnlyProxying;

    StaticServiceProxyCreator(Class[] classes, ClassLoader aopClassLoader, ClassLoader bundleClassLoader, BundleContext bundleContext, ImportContextClassLoader iccl, boolean greedyProxying) {
        super(classes, aopClassLoader, bundleClassLoader, bundleContext, iccl);
        String msg;
        this.greedyProxying = greedyProxying;
        boolean onlyInterfaces = true;
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].isInterface()) continue;
            onlyInterfaces = false;
        }
        this.interfacesOnlyProxying = onlyInterfaces;
        String string = msg = this.interfacesOnlyProxying ? "NOT" : "";
        if (log.isDebugEnabled()) {
            log.debug("Greedy proxying will " + msg + " consider exposed classes");
        }
    }

    ServiceInvoker createDispatcherInterceptor(ServiceReference reference) {
        return new ServiceStaticInterceptor(this.bundleContext, reference);
    }

    Advice createServiceProviderTCCLAdvice(ServiceReference reference) {
        Bundle bundle = reference.getBundle();
        if (bundle == null) {
            return null;
        }
        return new ServiceTCCLInterceptor(ClassLoaderFactory.getBundleClassLoaderFor(bundle));
    }

    Class[] discoverProxyClasses(ServiceReference ref) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Generating greedy proxy for service " + OsgiStringUtils.nullSafeToString(ref));
        }
        Object[] classNames = OsgiServiceReferenceUtils.getServiceObjectClasses(ref);
        if (trace) {
            log.trace("Discovered raw classes " + ObjectUtils.nullSafeToString(classNames));
        }
        Object[] classes = ClassUtils.loadClasses((String[])classNames, this.classLoader);
        if (trace) {
            log.trace("Visible classes are " + ObjectUtils.nullSafeToString(classes));
        }
        classes = ClassUtils.excludeClassesWithModifier((Class[])classes, 16);
        if (trace) {
            log.trace("Filtering out final classes; left out with " + ObjectUtils.nullSafeToString(classes));
        }
        if (this.interfacesOnlyProxying) {
            LinkedHashSet<Object> clazzes = new LinkedHashSet<Object>(classes.length);
            for (int classIndex = 0; classIndex < classes.length; ++classIndex) {
                Object clazz = classes[classIndex];
                if (!((Class)clazz).isInterface()) continue;
                clazzes.add(clazz);
            }
            if (trace) {
                log.trace("Filtering out concrete classes; left out with " + clazzes);
            }
            classes = clazzes.toArray(new Class[clazzes.size()]);
        }
        classes = ClassUtils.removeParents((Class[])classes);
        if (trace) {
            log.trace("Filtering out parent classes; left out with " + classes);
        }
        return classes;
    }

    Class[] getInterfaces(ServiceReference reference) {
        if (this.greedyProxying) {
            Object[] clazzes = this.discoverProxyClasses(reference);
            if (log.isTraceEnabled()) {
                log.trace("generating 'greedy' service proxy using classes " + ObjectUtils.nullSafeToString(clazzes) + " over " + ObjectUtils.nullSafeToString(this.classes));
            }
            return clazzes;
        }
        return this.classes;
    }
}

