/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.aop;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.service.importer.ServiceProxyDestroyedException;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceInvoker;
import org.springframework.util.Assert;

public class ServiceStaticInterceptor
extends ServiceInvoker {
    private static final int hashCode = ServiceStaticInterceptor.class.hashCode() * 13;
    private boolean destroyed = false;
    private final Object lock = new Object();
    private final ServiceReference reference;
    private final BundleContext bundleContext;

    public ServiceStaticInterceptor(BundleContext context, ServiceReference reference) {
        Assert.notNull(context);
        Assert.notNull(reference, "a not null service reference is required");
        this.bundleContext = context;
        this.reference = reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getTarget() {
        Object target;
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                throw new ServiceProxyDestroyedException();
            }
        }
        if (this.reference.getBundle() != null && (target = this.bundleContext.getService(this.reference)) != null) {
            return target;
        }
        throw new ServiceUnavailableException(this.reference);
    }

    public ServiceReference getServiceReference() {
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed = true;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServiceStaticInterceptor) {
            ServiceStaticInterceptor oth = (ServiceStaticInterceptor)other;
            return this.reference.equals(oth.reference) && this.bundleContext.equals(oth.bundleContext);
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }
}

