/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.aop;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.service.importer.support.internal.aop.BaseServiceReferenceProxy;
import org.springframework.util.Assert;

class SwappingServiceReferenceProxy
extends BaseServiceReferenceProxy {
    private static final int HASH_CODE = SwappingServiceReferenceProxy.class.hashCode() * 13;
    private ServiceReference delegate;

    SwappingServiceReferenceProxy() {
    }

    synchronized ServiceReference swapDelegates(ServiceReference newDelegate) {
        Assert.notNull(newDelegate);
        ServiceReference old = this.delegate;
        this.delegate = newDelegate;
        return old;
    }

    public synchronized Bundle getBundle() {
        return this.delegate == null ? null : this.delegate.getBundle();
    }

    public synchronized Object getProperty(String key) {
        return this.delegate == null ? null : this.delegate.getProperty(key);
    }

    public synchronized String[] getPropertyKeys() {
        return this.delegate == null ? new String[]{} : this.delegate.getPropertyKeys();
    }

    public synchronized Bundle[] getUsingBundles() {
        return this.delegate == null ? new Bundle[]{} : this.delegate.getUsingBundles();
    }

    public synchronized boolean isAssignableTo(Bundle bundle, String className) {
        return this.delegate == null ? false : this.delegate.isAssignableTo(bundle, className);
    }

    public synchronized ServiceReference getTargetServiceReference() {
        return this.delegate;
    }

    public synchronized boolean equals(Object obj) {
        if (obj instanceof SwappingServiceReferenceProxy) {
            SwappingServiceReferenceProxy other = (SwappingServiceReferenceProxy)obj;
            return this.delegate == null ? other.delegate == null : this.delegate.equals(other.delegate);
        }
        return false;
    }

    public synchronized int hashCode() {
        return HASH_CODE + (this.delegate == null ? 0 : this.delegate.hashCode());
    }

    public synchronized int compareTo(Object other) {
        if (other instanceof SwappingServiceReferenceProxy) {
            return COMPARATOR.compare(this.delegate, ((SwappingServiceReferenceProxy)other).delegate);
        }
        return COMPARATOR.compare(this.delegate, other);
    }
}

