/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.service.importer.DefaultOsgiServiceDependency;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.service.importer.OsgiServiceDependency;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.ServiceReferenceProxy;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.service.importer.support.internal.aop.ProxyPlusCallback;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceProxyCreator;
import org.springframework.osgi.service.importer.support.internal.collection.CollectionProxy;
import org.springframework.osgi.service.importer.support.internal.collection.DynamicCollection;
import org.springframework.osgi.service.importer.support.internal.dependency.ImporterStateListener;
import org.springframework.osgi.service.importer.support.internal.util.OsgiServiceBindingUtils;
import org.springframework.osgi.util.OsgiListenerUtils;
import org.springframework.util.Assert;

public class OsgiServiceCollection
implements Collection,
InitializingBean,
CollectionProxy,
DisposableBean {
    private static final Log log = LogFactory.getLog(OsgiServiceCollection.class);
    private static final Log PUBLIC_LOGGER = LogFactory.getLog(OsgiServiceCollectionProxyFactoryBean.class);
    protected final Map servicesIdMap = new LinkedHashMap(8);
    protected DynamicCollection serviceProxies;
    private boolean serviceRequiredAtStartup = true;
    private final Filter filter;
    private final BundleContext context;
    private final ClassLoader classLoader;
    private final ServiceProxyCreator proxyCreator;
    private OsgiServiceLifecycleListener[] listeners = new OsgiServiceLifecycleListener[0];
    private final ServiceListener listener;
    private List stateListeners = Collections.EMPTY_LIST;
    private final Object lock = new Object();
    private OsgiServiceDependency dependency;
    private Object eventSource;
    private String sourceName;

    public OsgiServiceCollection(Filter filter, BundleContext context, ClassLoader classLoader, ServiceProxyCreator proxyCreator) {
        Assert.notNull(classLoader, "ClassLoader is required");
        Assert.notNull(context, "context is required");
        this.filter = filter;
        this.context = context;
        this.classLoader = classLoader;
        this.proxyCreator = proxyCreator;
        this.listener = new Listener();
    }

    public void afterPropertiesSet() {
        this.serviceProxies = this.createInternalDynamicStorage();
        this.dependency = new DefaultOsgiServiceDependency(this.sourceName, this.filter, this.serviceRequiredAtStartup);
        if (log.isTraceEnabled()) {
            log.trace("Adding osgi listener for services matching [" + this.filter + "]");
        }
        OsgiListenerUtils.addServiceListener(this.context, this.listener, this.filter);
        if (this.serviceRequiredAtStartup) {
            if (log.isDebugEnabled()) {
                log.debug("1..x cardinality - looking for service [" + this.filter + "] at startup...");
            }
            PUBLIC_LOGGER.info("Looking for mandatory OSGi service dependency for bean [" + this.sourceName + "] matching filter " + this.filter);
            this.mandatoryServiceCheck();
            PUBLIC_LOGGER.info("Found mandatory OSGi service for bean [" + this.sourceName + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        OsgiListenerUtils.removeServiceListener(this.context, this.listener);
        DynamicCollection dynamicCollection = this.serviceProxies;
        synchronized (dynamicCollection) {
            Iterator iterator = this.serviceProxies.iterator();
            while (iterator.hasNext()) {
                ImportedOsgiServiceProxy serviceProxy = (ImportedOsgiServiceProxy)iterator.next();
                ServiceReferenceProxy ref = serviceProxy.getServiceReference();
                ProxyPlusCallback ppc = (ProxyPlusCallback)this.servicesIdMap.get((Long)ref.getProperty("service.id"));
                this.listener.serviceChanged(new ServiceEvent(4, (ServiceReference)ref));
                try {
                    ppc.destructionCallback.destroy();
                }
                catch (Exception ex) {
                    log.error("Exception occurred while destroying proxy " + ppc.proxy, ex);
                }
            }
            this.serviceProxies.clear();
            this.servicesIdMap.clear();
        }
    }

    protected void mandatoryServiceCheck() {
        if (this.serviceRequiredAtStartup && this.serviceProxies.isEmpty()) {
            throw new ServiceUnavailableException(this.filter);
        }
    }

    public boolean isSatisfied() {
        if (this.serviceRequiredAtStartup) {
            return !this.serviceProxies.isEmpty();
        }
        return true;
    }

    protected DynamicCollection createInternalDynamicStorage() {
        return new DynamicCollection();
    }

    private void invalidateProxy(ProxyPlusCallback ppc) {
    }

    public void setServiceImporter(Object importer) {
        this.eventSource = importer;
    }

    public void setServiceImporterName(String name) {
        this.sourceName = name;
    }

    public Iterator iterator() {
        return new OsgiServiceIterator();
    }

    public int size() {
        this.mandatoryServiceCheck();
        return this.serviceProxies.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.mandatoryServiceCheck();
        DynamicCollection dynamicCollection = this.serviceProxies;
        synchronized (dynamicCollection) {
            return this.serviceProxies.toString();
        }
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object o) {
        this.mandatoryServiceCheck();
        return this.serviceProxies.contains(o);
    }

    public boolean containsAll(Collection c) {
        this.mandatoryServiceCheck();
        return this.serviceProxies.containsAll(c);
    }

    public boolean isEmpty() {
        this.mandatoryServiceCheck();
        return this.size() == 0;
    }

    public Object[] toArray() {
        this.mandatoryServiceCheck();
        return this.serviceProxies.toArray();
    }

    public Object[] toArray(Object[] array) {
        this.mandatoryServiceCheck();
        return this.serviceProxies.toArray(array);
    }

    public void setListeners(OsgiServiceLifecycleListener[] listeners) {
        Assert.notNull(listeners);
        this.listeners = listeners;
    }

    public void setRequiredAtStartup(boolean serviceRequiredAtStartup) {
        this.serviceRequiredAtStartup = serviceRequiredAtStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateListeners(List stateListeners) {
        Object object = this.lock;
        synchronized (object) {
            this.stateListeners = stateListeners;
        }
    }

    protected class OsgiServiceIterator
    implements Iterator {
        private final Iterator iter;

        protected OsgiServiceIterator() {
            this.iter = OsgiServiceCollection.this.serviceProxies.iterator();
        }

        public boolean hasNext() {
            OsgiServiceCollection.this.mandatoryServiceCheck();
            return this.iter.hasNext();
        }

        public Object next() {
            OsgiServiceCollection.this.mandatoryServiceCheck();
            return this.iter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Listener
    implements ServiceListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void serviceChanged(ServiceEvent event) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(OsgiServiceCollection.this.classLoader);
                ServiceReference ref = event.getServiceReference();
                Long serviceId = (Long)ref.getProperty("service.id");
                boolean collectionModified = false;
                ProxyPlusCallback ppc = null;
                ImportedOsgiServiceProxy proxy = null;
                boolean shouldInformStateListeners = false;
                switch (event.getType()) {
                    case 1: 
                    case 2: {
                        DynamicCollection dynamicCollection = OsgiServiceCollection.this.serviceProxies;
                        synchronized (dynamicCollection) {
                            if (!OsgiServiceCollection.this.servicesIdMap.containsKey(serviceId)) {
                                ppc = OsgiServiceCollection.this.proxyCreator.createServiceProxy(ref);
                                proxy = ppc.proxy;
                                if (OsgiServiceCollection.this.serviceProxies.add(proxy)) {
                                    collectionModified = true;
                                    shouldInformStateListeners = OsgiServiceCollection.this.serviceProxies.size() == 1;
                                    OsgiServiceCollection.this.servicesIdMap.put(serviceId, ppc);
                                }
                            }
                        }
                        if (!collectionModified) return;
                        OsgiServiceBindingUtils.callListenersBind(OsgiServiceCollection.this.context, proxy, ref, OsgiServiceCollection.this.listeners);
                        if (!OsgiServiceCollection.this.serviceRequiredAtStartup || !shouldInformStateListeners) return;
                        this.notifySatisfiedStateListeners();
                        return;
                    }
                    case 4: {
                        DynamicCollection dynamicCollection = OsgiServiceCollection.this.serviceProxies;
                        synchronized (dynamicCollection) {
                            ppc = (ProxyPlusCallback)OsgiServiceCollection.this.servicesIdMap.remove(serviceId);
                            if (ppc != null) {
                                proxy = ppc.proxy;
                                collectionModified = OsgiServiceCollection.this.serviceProxies.remove(proxy);
                                OsgiServiceCollection.this.invalidateProxy(ppc);
                                shouldInformStateListeners = OsgiServiceCollection.this.serviceProxies.isEmpty();
                            }
                        }
                        if (!collectionModified) return;
                        OsgiServiceBindingUtils.callListenersUnbind(OsgiServiceCollection.this.context, proxy, ref, OsgiServiceCollection.this.listeners);
                        if (!OsgiServiceCollection.this.serviceRequiredAtStartup || !shouldInformStateListeners) return;
                        this.notifyUnsatisfiedStateListeners();
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported event type:" + event);
                    }
                }
            }
            catch (Throwable re) {
                if (!log.isWarnEnabled()) return;
                log.warn("serviceChanged() processing failed", re);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifySatisfiedStateListeners() {
            List list = OsgiServiceCollection.this.stateListeners;
            synchronized (list) {
                Iterator iterator = OsgiServiceCollection.this.stateListeners.iterator();
                while (iterator.hasNext()) {
                    ImporterStateListener stateListener = (ImporterStateListener)iterator.next();
                    stateListener.importerSatisfied(OsgiServiceCollection.this.eventSource, OsgiServiceCollection.this.dependency);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyUnsatisfiedStateListeners() {
            List list = OsgiServiceCollection.this.stateListeners;
            synchronized (list) {
                Iterator iterator = OsgiServiceCollection.this.stateListeners.iterator();
                while (iterator.hasNext()) {
                    ImporterStateListener stateListener = (ImporterStateListener)iterator.next();
                    stateListener.importerUnsatisfied(OsgiServiceCollection.this.eventSource, OsgiServiceCollection.this.dependency);
                }
            }
        }
    }
}

