/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.MethodInvokingRunnable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
EmbeddedValueResolverAware,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private Object scheduler;
    private StringValueResolver embeddedValueResolver;
    private ApplicationContext applicationContext;
    private final ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
    private final Map<Runnable, String> cronTasks = new HashMap<Runnable, String>();
    private final Map<Runnable, Long> fixedDelayTasks = new HashMap<Runnable, Long>();
    private final Map<Runnable, Long> fixedRateTasks = new HashMap<Runnable, Long>();

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver2) {
        this.embeddedValueResolver = resolver2;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(final Object bean, String beanName) {
        Class<?> targetClass = AopUtils.getTargetClass(bean);
        ReflectionUtils.doWithMethods(targetClass, new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Scheduled annotation2 = AnnotationUtils.getAnnotation(method, Scheduled.class);
                if (annotation2 != null) {
                    long fixedRate;
                    long fixedDelay;
                    Assert.isTrue(Void.TYPE.equals(method.getReturnType()), "Only void-returning methods may be annotated with @Scheduled.");
                    Assert.isTrue(method.getParameterTypes().length == 0, "Only no-arg methods may be annotated with @Scheduled.");
                    MethodInvokingRunnable runnable = new MethodInvokingRunnable();
                    runnable.setTargetObject(bean);
                    runnable.setTargetMethod(method.getName());
                    runnable.setArguments(new Object[0]);
                    try {
                        runnable.prepare();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("failed to prepare task", ex);
                    }
                    boolean processedSchedule = false;
                    String errorMessage = "Exactly one of 'cron', 'fixedDelay', or 'fixedRate' is required.";
                    String cron = annotation2.cron();
                    if (!"".equals(cron)) {
                        processedSchedule = true;
                        if (ScheduledAnnotationBeanPostProcessor.this.embeddedValueResolver != null) {
                            cron = ScheduledAnnotationBeanPostProcessor.this.embeddedValueResolver.resolveStringValue(cron);
                        }
                        ScheduledAnnotationBeanPostProcessor.this.cronTasks.put(runnable, cron);
                    }
                    if ((fixedDelay = annotation2.fixedDelay()) >= 0L) {
                        Assert.isTrue(!processedSchedule, errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedDelayTasks.put(runnable, fixedDelay);
                    }
                    if ((fixedRate = annotation2.fixedRate()) >= 0L) {
                        Assert.isTrue(!processedSchedule, errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedRateTasks.put(runnable, fixedRate);
                    }
                    Assert.isTrue(processedSchedule, errorMessage);
                }
            }
        });
        return bean;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            if (this.scheduler != null) {
                this.registrar.setScheduler(this.scheduler);
            }
            this.registrar.setCronTasks(this.cronTasks);
            this.registrar.setFixedDelayTasks(this.fixedDelayTasks);
            this.registrar.setFixedRateTasks(this.fixedRateTasks);
            this.registrar.afterPropertiesSet();
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.registrar != null) {
            this.registrar.destroy();
        }
    }
}

