/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.services.api;

import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.dosgi.services.AbstractModelBusActivator;
import org.modelbus.dosgi.services.api.ModelBusServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractModelBusConsumerActivator
extends AbstractModelBusActivator {
    private ModelBusServiceTracker mbSt;
    private ServiceReference serviceReference;

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        instances.put(this.getServiceInterface().getName(), this);
        Class<?> serviceClass = this.getServiceInterface();
        System.out.println("Starting service consumer: " + serviceClass.getName());
        this.mbSt = new ModelBusServiceTracker(this);
        this.mbSt.start();
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.mbSt.close();
    }

    public static final AbstractModelBusConsumerActivator getDefault(Class<?> serviceInterface) {
        return (AbstractModelBusConsumerActivator)instances.get(serviceInterface.getName());
    }

    public final void setServiceReference(ServiceReference ref) {
        this.serviceReference = ref;
        try {
            ModelBusServiceConfiguration config = this.getConfiguration();
            System.out.println("Service consumer started: " + this.getServiceInterface().getName() + ", target service at: " + config.getOption("serviceAddress"));
            this.serviceRegistered(this.getService());
        }
        catch (ModelBusServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getService() throws ModelBusServiceException {
        if (this.serviceReference == null) {
            throw new ModelBusServiceException("No service registered for service interface: " + this.getServiceInterface().getName());
        }
        if (this.context == null) {
            throw new ModelBusServiceException("Missing bundle context for ModelBus Service: " + this.getClass().getName());
        }
        Object svc = this.context.getService(this.serviceReference);
        Class<?> clazz = this.getServiceInterface();
        if (clazz.isAssignableFrom(svc.getClass())) {
            return svc;
        }
        throw new ModelBusServiceException("Unexpected service type for service interface: " + this.getServiceInterface().getName());
    }

    protected abstract void serviceRegistered(Object var1);
}

