/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.services.api;

import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;
import org.modelbus.dosgi.services.api.AbstractModelBusConsumerActivator;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ModelBusServiceTracker
extends Thread {
    private ServiceTracker tracker;
    private ServiceTracker repoServiceTracker;
    private AbstractModelBusConsumerActivator consumer;
    private ServiceReference serviceReference;
    private ServiceReference repoServiceReference;
    private boolean notified = false;
    private boolean kill = false;

    public ModelBusServiceTracker(AbstractModelBusConsumerActivator consumer) {
        super("ServiceTracker " + consumer.getServiceInterface().getName());
        this.consumer = consumer;
    }

    @Override
    public void run() {
        Class<?> serviceInterface = this.consumer.getServiceInterface();
        this.tracker = new ServiceTracker(this.consumer.getBundleContext(), serviceInterface.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                ModelBusServiceTracker.this.serviceReference = reference;
                if (ModelBusServiceTracker.this.repoServiceTracker == null || ModelBusServiceTracker.this.repoServiceTracker != null && ModelBusServiceTracker.this.repoServiceReference != null) {
                    ModelBusServiceTracker.this.notifyAboutServiceReference();
                }
                return svc;
            }

            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                ModelBusServiceTracker.this.serviceReference = null;
                ModelBusServiceTracker.this.notifyAboutServiceReference();
            }
        };
        this.tracker.open();
        if (!serviceInterface.getName().equals(RepositoryService.class.getName())) {
            this.repoServiceTracker = new ServiceTracker(this.consumer.getBundleContext(), RepositoryService.class.getName(), null){

                public Object addingService(ServiceReference reference) {
                    Object svc = super.addingService(reference);
                    ModelBusServiceTracker.this.repoServiceReference = reference;
                    if (ModelBusServiceTracker.this.serviceReference != null) {
                        ModelBusServiceTracker.this.notifyAboutServiceReference();
                    }
                    return svc;
                }

                public void removedService(ServiceReference reference, Object service) {
                    super.removedService(reference, service);
                    ModelBusServiceTracker.this.repoServiceReference = null;
                }
            };
            this.repoServiceTracker.open();
        }
        while (!this.kill) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void waitForService(long time) throws ModelBusServiceException {
        try {
            this.tracker.waitForService(time);
        }
        catch (InterruptedException e) {
            throw new ModelBusServiceException((Throwable)e);
        }
    }

    private void notifyAboutServiceReference() {
        if (this.notified) {
            return;
        }
        this.notified = true;
        this.consumer.setServiceReference(this.serviceReference);
    }

    public void close() {
        this.kill = true;
        this.tracker.close();
        if (this.repoServiceTracker != null) {
            this.repoServiceTracker.close();
        }
    }
}

