package org.modelbus.library.example.service;

import java.util.Collections;
import java.util.List;

import library.Library;
import library.LibraryFactory;
import library.LibraryPackage;
import library.Writer;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.dosgi.api.AbstractModelBusAdapterConsumerActivator;
import org.modelbus.dosgi.repository.descriptor.Property;
import org.modelbus.dosgi.repository.descriptor.Session;
import org.osgi.framework.BundleContext;

public class Activator extends AbstractModelBusAdapterConsumerActivator {
	
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
	
	@Override
	protected void serviceRegistered(Object service) {
		Session session = new Session();
		session.setId(EcoreUtil.generateUUID());
		Property propertyUserName = new Property();
		propertyUserName.setKey("username");
		propertyUserName.setValue("Admin");
		Property propertyPassword = new Property();
		propertyPassword.setKey("password");
		propertyPassword.setValue("ModelBus");

		session.getProperties().add(propertyUserName);
		session.getProperties().add(propertyPassword);
		
		final LibraryService libraryService = (LibraryService)service;
		
		final ResourceSet set = new ResourceSetImpl();
		Resource res1 = set.createResource(URI.createURI("http://library.modelbus.org/demo.library"));
		
		final EPackage p = LibraryPackage.eINSTANCE;

		Library library = LibraryFactory.eINSTANCE.createLibrary();
		library.setName("Demo library");
		
		res1.getContents().add(library);
		
		System.out.println("Performing library service: isLibraryModelValid");
		boolean modelValid = libraryService.isLibraryModelValid(library);
		
		System.out.println("Model valid: " + modelValid);
		
		final String[] writerNames = new String[] { "Peter York", "Susan Oxford", "Brian Woodstock", "Catherine Jones", "" };
		
		for(final String writerName : writerNames){
			System.out.println("Performing library service: addWriter " + writerName);
			libraryService.addWriter(library, writerName);
			
			//checkout modified library
			final Resource res2 = set.createResource(URI.createURI("http://library.modelbus.org/demo.library"));
			
			try {
				this.getRepositoryHelper().checkOutModel(session, res2,Collections.EMPTY_MAP);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
			
			library = (Library)res2.getContents().get(0);
			
			System.out.println("Performing library service: getWriters");
			final List<Writer> writers = libraryService.getWriters(library);
			
			System.out.println("Writers:");
			System.out.println("========");
			
			for(final Writer currentWriter : writers){
				System.out.println(currentWriter.getName());
			}
			
			System.out.println("Performing library service: isLibraryModelValid");
			modelValid = libraryService.isLibraryModelValid(library);
			
			System.out.println("Model valid: " + modelValid);
		}
	}
	
	@Override
	protected void configure(ModelBusServiceConfiguration config) {
		// TODO Auto-generated method stub
	}

	@SuppressWarnings("unchecked")
	@Override
	protected Class getServiceInterface() {
		return LibraryService.class;
	}

	/*@Override
	public void registerRepositoryHelper(RepositoryHelper helper) {
		System.out.println("Library consumer: core lib is there");
		this.repoHelper = helper;
	}*/
}
