package org.modelbus.library.example.service;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;

import library.Library;
import library.Writer;

@WebService(targetNamespace = "http://www.modelbus.org/LibraryService/", name = "LibraryService")
public interface LibraryService {
	@WebMethod(action = "http://www.modelbus.org/LibraryService/addWriter")
	public void addWriter(
			@WebParam(name = "library", targetNamespace = "http://www.modelbus.org/LibraryService/")
			Library library,
			@WebParam(name = "name", targetNamespace = "http://www.modelbus.org/LibraryService/")
			String name
	);
	
	@WebMethod(action = "http://www.modelbus.org/LibraryService/isLibraryModelValid")
	@WebResult(name = "valid", targetNamespace = "")
	public boolean isLibraryModelValid(
			@WebParam(name = "library", targetNamespace = "http://www.modelbus.org/LibraryService/")
			Library library
	);
	
	@WebMethod(action = "http://www.modelbus.org/LibraryService/getWriters")
	@WebResult(name = "writers", targetNamespace = "")
	public List<Writer> getWriters(
			@WebParam(name = "library", targetNamespace = "http://www.modelbus.org/LibraryService/")
			Library library
	);
	
	@WebMethod(action = "http://www.modelbus.org/LibraryService/getLooseWriters")
	@WebResult(name = "looseWriters", targetNamespace = "")
	public List<Writer> getLooseWriters(
			@WebParam(name = "library", targetNamespace = "http://www.modelbus.org/LibraryService/")
			Library library
	);
}
