package org.modelbus.library.example.service;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.oslo.ocl20.OclProcessor;
import org.oslo.ocl20.bridge4emf.EmfOclProcessorImpl;
import org.oslo.ocl20.semantics.bridge.Environment;
import org.oslo.ocl20.synthesis.RuntimeEnvironment;

public class OsloOCLEvaluator {
	private OclProcessor	processor;

	public OsloOCLEvaluator() {
		this.processor = new EmfOclProcessorImpl(new ExceptionLog());
	}

	@SuppressWarnings("unchecked")
	public List<Object> evaluateExpression(final EObject eobject, final String expression) {
		final Environment env = this.processor.environment("self", eobject.getClass());
		final RuntimeEnvironment renv = this.processor.runtimeEnvironment("self", eobject);

		System.out.println("\tExpression: " + expression + " (on: " + eobject + ")");

		List<Object> results = null;
		try {
			results = this.processor.evaluate(expression, env, renv, this.processor.getLog());
		} catch (Exception e) {
			e.printStackTrace();
		}

		return results;
	}

	public EPackage addModel(final EPackage model) {
		this.processor.addModel(model);

		return model;
	}

	public void createOCLOperation(final String def) {
		System.out.println("\tCreating OCL expression: " + def);
		this.processor.analyse(def);
	}
}
