/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.papyrus.eclipse.adapter.actions;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.ui.LockHelper;

public class DiagramLockAction
implements IObjectActionDelegate {
    private EObject selectedObject;

    public void run(IAction action) {
        if (this.selectedObject != null) {
            Resource objectResource = this.selectedObject.eResource();
            String objectUri = objectResource.getURIFragment(this.selectedObject);
            try {
                String objectLocation = LockHelper.getLockHelper().getObjectLocation(objectResource.getURI(), objectUri);
                if (objectLocation != null) {
                    URI uri = URI.createURI((String)objectLocation);
                    IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                    repositoryHelper.lock(UserSessionHelper.getSession(), uri);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object model;
        Object firstObject;
        if (selection instanceof IStructuredSelection && (firstObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IGraphicalEditPart && (model = ((IGraphicalEditPart)firstObject).getModel()) instanceof View) {
            EObject eObject = ((View)model).getElement();
            try {
                String user = LockHelper.getLockHelper().objectLockedBy((Object)eObject);
                if (user == null) {
                    this.selectedObject = eObject;
                    action.setEnabled(true);
                    return;
                }
            }
            catch (Exception exception) {
                this.selectedObject = null;
                action.setEnabled(false);
            }
        }
        this.selectedObject = null;
        action.setEnabled(false);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

