/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.papyrus.eclipse.adapter.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.modelexplorer.factory.IActionHandlerFactory;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.modelbus.papyrus.eclipse.adapter.actions.LockAction;
import org.modelbus.papyrus.eclipse.adapter.actions.UnlockAction;
import org.modelbus.papyrus.eclipse.adapter.lockregistry.ModelBusLockResourceSetListener;

public class LockActionHandlerFactory
implements IActionHandlerFactory {
    protected List<Action> actions = new LinkedList<Action>();
    protected LockAction lockAction;
    protected UnlockAction unlockAction;
    private static ResourceSetListener resourceSetListener = null;

    public void activate(CommonNavigator activeViewPart) {
        this.lockAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        this.unlockAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        CommonViewer selectionProvider = null;
        if (activeViewPart.getCommonViewer() instanceof ISelectionProvider) {
            selectionProvider = activeViewPart.getCommonViewer();
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.lockAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.unlockAction);
        }
    }

    public List<Action> createActions(EditingDomain editingDomain) {
        this.lockAction = new LockAction(editingDomain);
        this.unlockAction = new UnlockAction(editingDomain);
        this.actions.add((Action)this.lockAction);
        this.actions.add((Action)this.unlockAction);
        return this.actions;
    }

    public void deactivate(CommonNavigator activeViewPart) {
        this.lockAction.setActiveWorkbenchPart(null);
        this.unlockAction.setActiveWorkbenchPart(null);
        CommonViewer selectionProvider = null;
        if (activeViewPart.getCommonViewer() instanceof ISelectionProvider) {
            selectionProvider = activeViewPart.getCommonViewer();
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.lockAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.unlockAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.getMenuManager().add((IAction)this.lockAction);
        actionBars.getMenuManager().add((IAction)this.unlockAction);
        actionBars.updateActionBars();
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void update(IStructuredSelection structuredSelection) {
        this.lockAction.updateSelection(structuredSelection);
        this.unlockAction.updateSelection(structuredSelection);
    }

    private ResourceSetListener getResourceSetListener() {
        if (resourceSetListener == null) {
            resourceSetListener = new ModelBusLockResourceSetListener();
        }
        return resourceSetListener;
    }
}

