/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.papyrus.eclipse.adapter.actions;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.modelexplorer.NavigatorUtils;
import org.eclipse.ui.IWorkbenchPart;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.ui.LockHelper;

public class UnlockAction
extends CommandActionHandler {
    private EObject selectedNamedElement = null;

    public UnlockAction(EditingDomain editingDomain) {
        super(editingDomain, "Unlock Element");
    }

    protected EObject getSelectedNamedElement() {
        return this.selectedNamedElement;
    }

    protected void setSelectedNamedElement(EObject selectedNamedElement) {
        this.selectedNamedElement = selectedNamedElement;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object selectedObject;
        StructuredSelection structuredSelection;
        ISelection unwrappedselection = NavigatorUtils.unwrapSelection((ISelection)selection);
        if (unwrappedselection instanceof StructuredSelection && (structuredSelection = (StructuredSelection)unwrappedselection).size() == 1 && (selectedObject = structuredSelection.getFirstElement()) instanceof EObject) {
            try {
                String user = LockHelper.getLockHelper().objectLockedBy(selectedObject);
                if (user != null && user.equals(UserSessionHelper.getPropertyUserName()) && LockHelper.getLockHelper().isDirectLocked(selectedObject)) {
                    this.setSelectedNamedElement((EObject)selectedObject);
                    return super.updateSelection(selection);
                }
            }
            catch (Exception exception) {
                this.setSelectedNamedElement(null);
                return false;
            }
        }
        this.setSelectedNamedElement(null);
        return false;
    }

    public Command createCommand(Collection<?> selection) {
        TransactionalEditingDomain domain = this.getTransactionalEditingDomain();
        if (domain == null) {
            return null;
        }
        return new RecordingCommand(domain){

            protected void doExecute() {
                if (UnlockAction.this.selectedNamedElement != null) {
                    EObject object = UnlockAction.this.selectedNamedElement;
                    Resource objectResource = object.eResource();
                    String objectUri = objectResource.getURIFragment(object);
                    try {
                        String objectLocation = LockHelper.getLockHelper().getObjectLocation(objectResource.getURI(), objectUri);
                        if (objectLocation != null) {
                            URI uri = URI.createURI((String)objectLocation);
                            IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
                            repositoryHelper.unlock(UserSessionHelper.getSession(), uri);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    protected TransactionalEditingDomain getTransactionalEditingDomain() {
        if (this.getEditingDomain() instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)this.getEditingDomain();
        }
        return null;
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }
}

