/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.papyrus.v9.eclipse.adapter.decorator;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.modelbus.core.lib.notification.INotificationListener;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.papyrus.v9.eclipse.adapter.Activator;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryPlugin;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.repository.ui.LockHelper;
import org.osgi.framework.Bundle;

public class ModelBusLockDecorator
extends AbstractDecorator
implements IPartListener,
INotificationListener,
Observer,
IPropertyChangeListener {
    private final String UNLOCKED_ICON_PATH = "icons/lock_green_big.gif";
    private final String LOCKED_ICON_PATH = "icons/lock_red_big.gif";
    private boolean isEnabled = true;
    private static boolean repositoryIsAvailable;

    public ModelBusLockDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void activate() {
        this.refresh();
    }

    public void refresh() {
        if (this.isEnabled) {
            this.removeDecoration();
            Shape shape = (Shape)this.getDecoratorTarget().getAdapter(Shape.class);
            if (shape == null) {
                return;
            }
            EObject element = shape.getElement();
            String user = LockHelper.getLockHelper().objectLockedBy((Object)element);
            if (user == null) {
                return;
            }
            if (user.equals(UserSessionHelper.getPropertyUserName())) {
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.createImageDescriptor("icons/lock_green_big.gif"), IDecoratorTarget.Direction.NORTH_EAST, -2, true));
            } else {
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.createImageDescriptor("icons/lock_red_big.gif"), IDecoratorTarget.Direction.NORTH_EAST, -2, true));
            }
        }
    }

    private Image createImageDescriptor(String id) {
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(id), null);
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    public void commitChangeModelNotification(String arg0, String arg1, String arg2) {
    }

    public void notification(String url, String mode, String user, String sessionID) {
        if ("http://www.modelbus.org/system/model/ModelBus.lock".equals(url) && repositoryIsAvailable) {
            LockHelper.resetLockHelper();
            this.refresh();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setRepositoryStatus(ModelBusRepositoryPlugin.getPlugin().getRepositoryStatus().isAvailable());
    }

    private void setRepositoryStatus(boolean isAvailable) {
        repositoryIsAvailable = isAvailable;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "DiagramLockDecoratorPreference") {
            this.isEnabled = (Boolean)event.getNewValue();
            if (!this.isEnabled) {
                this.removeDecoration();
            } else {
                this.refresh();
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        DecorationEditPolicy.DecoratorTarget target = this.getDecoratorTarget();
        Shape shape = (Shape)target.getAdapter(Shape.class);
        if (shape == null) {
            NotificationListenerManager.getNotificationListenerManager().removeNotificationListener((INotificationListener)this);
        }
        if (part instanceof CoreMultiDiagramEditor) {
            Diagram diagram;
            IEditorInput editorInput = ((CoreMultiDiagramEditor)part).getEditorInput();
            String lastSegment = "";
            if (editorInput instanceof FileEditorInput) {
                lastSegment = ((FileEditorInput)editorInput).getPath().lastSegment();
            }
            if (shape != null && ((diagram = shape.getDiagram()) == null || lastSegment.equals(EcoreUtil.getURI((EObject)diagram).lastSegment()))) {
                NotificationListenerManager.getNotificationListenerManager().removeNotificationListener((INotificationListener)this);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

