/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.papyrus.v9.eclipse.adapter.decorator;

import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PlatformUI;
import org.modelbus.core.lib.notification.INotificationListener;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.papyrus.v9.eclipse.adapter.decorator.ModelBusLockDecorator;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryDecoratorPing;
import org.modelbus.team.eclipse.repository.ui.ModelBusRepositoryStatus;

public class ModelbusLockDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    private static final String DECORATOR_LOCK = "Modelbus.Lock.Decorator";
    private static ModelBusRepositoryDecoratorPing modelBusRepositoryDecoratorPing;
    private static NotificationListenerManager nManager;
    private static final int pingInterval = 5000;
    private static ModelBusRepositoryStatus modelBusRepositoryStatus;

    public ModelbusLockDecoratorProvider() {
        this.initialize();
    }

    private void initialize() {
        if (nManager == null) {
            nManager = NotificationListenerManager.getNotificationListenerManager();
        }
        if (modelBusRepositoryDecoratorPing == null) {
            modelBusRepositoryDecoratorPing = new ModelBusRepositoryDecoratorPing(5000L);
            modelBusRepositoryDecoratorPing.start();
        }
        if (modelBusRepositoryStatus == null) {
            modelBusRepositoryStatus = new ModelBusRepositoryStatus();
        }
    }

    public boolean provides(IOperation operation) {
        Assert.isNotNull((Object)operation);
        if (!(operation instanceof CreateDecoratorsOperation)) {
            return false;
        }
        IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        Object adapter = decoratorTarget.getAdapter(Shape.class);
        return adapter != null;
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        Shape shape = (Shape)decoratorTarget.getAdapter(Shape.class);
        ModelBusLockDecorator modelBusLockDecorator = new ModelBusLockDecorator(decoratorTarget);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)modelBusLockDecorator);
        nManager.addNotificationListener((INotificationListener)modelBusLockDecorator);
        modelBusRepositoryStatus.addObserver((Observer)modelBusLockDecorator);
        if (shape != null) {
            decoratorTarget.installDecorator((Object)DECORATOR_LOCK, (IDecorator)modelBusLockDecorator);
        }
    }
}

