/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.preferences.dependencies.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.modelbus.preferences.dependencies.DependenciesPreferencePlugin;

public class DependenciesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;
    private static final int LIST_HEIGHT_IN_CHARS = 10;
    private static final int LIST_HEIGHT_IN_DLUS = 80;
    private List modelExtensionList;
    private Text textField;
    private BooleanFieldEditor dependencies;
    private Button removeModelExtension;

    public DependenciesPreferencePage() {
        IPreferenceStore store = DependenciesPreferencePlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription("ModelBus Dependencies Preferences");
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 16384);
        top.setLayoutData((Object)new GridData(768));
        top.setLayout((Layout)new GridLayout());
        this.dependencies = new BooleanFieldEditor("CHECK_DEPENDENCIES_booleanPreference", "&Enable dependencies analysis", top);
        this.dependencies.setPreferencePage((PreferencePage)this);
        this.dependencies.setPreferenceStore(this.getPreferenceStore());
        this.dependencies.load();
        Label listLabel = new Label(top, 0);
        listLabel.setText("&Use models with the following file extensions:");
        this.modelExtensionList = new List(top, 2048);
        this.modelExtensionList.setItems(DependenciesPreferencePlugin.getDefault().getExtensionPreference());
        GridData listData = new GridData(768);
        listData.heightHint = this.convertVerticalDLUsToPixels(80);
        this.modelExtensionList.setLayoutData((Object)listData);
        this.modelExtensionList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependenciesPreferencePage.this.selectionChanged();
            }
        });
        Composite addRemoveGroup = new Composite(top, 0);
        addRemoveGroup.setLayoutData((Object)new GridData(768));
        GridLayout addRemoveLayout = new GridLayout();
        addRemoveLayout.numColumns = 2;
        addRemoveLayout.marginHeight = 0;
        addRemoveLayout.marginWidth = 0;
        addRemoveGroup.setLayout((Layout)addRemoveLayout);
        Composite buttonGroup = new Composite(addRemoveGroup, 0);
        buttonGroup.setLayoutData((Object)new GridData());
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonGroup.setLayout((Layout)buttonLayout);
        Button addModelExtension = new Button(buttonGroup, 0);
        addModelExtension.setText("Add File Extension");
        addModelExtension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependenciesPreferencePage.this.addExtension();
            }
        });
        GridData addExtensionData = new GridData(768);
        addModelExtension.setLayoutData((Object)addExtensionData);
        this.removeModelExtension = new Button(buttonGroup, 0);
        this.removeModelExtension.setText("&Remove File Extension");
        this.removeModelExtension.setEnabled(false);
        this.removeModelExtension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependenciesPreferencePage.this.modelExtensionList.remove(DependenciesPreferencePage.this.modelExtensionList.getSelectionIndex());
                DependenciesPreferencePage.this.selectionChanged();
            }
        });
        GridData removeExtensionData = new GridData(768);
        this.removeModelExtension.setLayoutData((Object)removeExtensionData);
        this.textField = new Text(addRemoveGroup, 2048);
        GridData textData = new GridData(768);
        textData.verticalAlignment = 1;
        this.textField.setLayoutData((Object)textData);
        return top;
    }

    public void init(IWorkbench wb) {
    }

    protected void performDefaults() {
        this.dependencies.loadDefault();
        this.modelExtensionList.setItems(DependenciesPreferencePlugin.getDefault().getDefaultExtensionPreference());
        super.performDefaults();
    }

    public boolean performOk() {
        this.dependencies.store();
        DependenciesPreferencePlugin.getDefault().setExtensionPreference(this.modelExtensionList.getItems());
        return super.performOk();
    }

    private void addExtension() {
        String extension = this.textField.getText();
        if (extension != null && extension.length() > 0) {
            this.modelExtensionList.add(extension);
        }
        this.textField.setText("");
    }

    private void selectionChanged() {
        int index = this.modelExtensionList.getSelectionIndex();
        this.removeModelExtension.setEnabled(index >= 0);
    }
}

