/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.preferences.user.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.modelbus.preferences.user.Activator;

public class ModelBusUserPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FileFieldEditor configFileEditor;
    private BooleanFieldEditor useSSLBooleanEditor;

    public ModelBusUserPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("ModelBus User Credentials");
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new StringFieldEditor("MODELBUS_USERNAME_stringPreference", "Username:", this.getFieldEditorParent()));
        Composite fieldEditorParent = this.getFieldEditorParent();
        StringFieldEditor stringFieldEditor = new StringFieldEditor("MODELBUS_PASSWORD_stringPreference", "Password:", fieldEditorParent);
        stringFieldEditor.getTextControl(this.getFieldEditorParent()).setEchoChar('*');
        stringFieldEditor.getLabelControl(fieldEditorParent);
        this.addField((FieldEditor)stringFieldEditor);
        this.configFileEditor = new FileFieldEditor("MODELBUS_CONFIG_MODEL_PATH_stringPreference", "Configuration Model:", true, this.getFieldEditorParent());
        this.configFileEditor.setFileExtensions(new String[]{"*.config"});
        this.addField((FieldEditor)this.configFileEditor);
        this.useSSLBooleanEditor = new BooleanFieldEditor("MODELBUS_USE_SSL_booleanPreference", "Use encrypted communication (SSL, requires restart)", this.getFieldEditorParent());
        this.addField((FieldEditor)this.useSSLBooleanEditor);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.useSSLBooleanEditor.getBooleanValue() && "".equals(this.configFileEditor.getStringValue())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Information", (String)"ModelBus configuration model path must be provided when using encrypted communication.");
            return false;
        }
        return super.performOk();
    }
}

