/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.changemodelnotification.commands;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelbus.core.lib.notification.INotificationListener;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.team.eclipse.changemodelnotification.Activator;
import org.modelbus.team.eclipse.changemodelnotification.listener.ModelBusExcecutionListener;
import org.modelbus.team.eclipse.changemodelnotification.listener.ModelbusChangeModelNotificationListener;
import org.modelbus.team.eclipse.changemodelnotification.listener.ModelbusChangeModelResourceSetListener;
import org.modelbus.team.eclipse.changemodelnotification.util.ChangeModelUtil;
import org.modelbus.team.eclipse.repository.RepositoryLocationHelper;

public class InteractiveButtonHandler
implements IHandler,
IPropertyChangeListener,
IPartListener {
    private ModelbusChangeModelResourceSetListener modelbusChangeModelResourceSetListener;
    private ModelbusChangeModelNotificationListener modelbusChangeModelNotificationListener;
    private HashMap<TransactionalEditingDomain, ModelBusExcecutionListener> domainToExecutionListenerMap;
    private boolean isActiveModeling = Activator.getDefault().getPreferenceStore().getBoolean("MODELBUS_automatic_update");
    private boolean isCommitOnSave = Activator.getDefault().getPreferenceStore().getBoolean("MODELBUS_commit_on_save");
    private boolean buttonPushed = false;
    private String repositoryLocation;
    private NotificationListenerManager notificationListenerManager;

    public InteractiveButtonHandler() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.modelbusChangeModelNotificationListener = new ModelbusChangeModelNotificationListener();
        this.modelbusChangeModelResourceSetListener = new ModelbusChangeModelResourceSetListener();
        this.domainToExecutionListenerMap = new HashMap();
        try {
            this.notificationListenerManager = NotificationListenerManager.getNotificationListenerManager();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        final InteractiveButtonHandler partListener = this;
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    window.getActivePage().addPartListener(partListener);
                }
            }
        });
    }

    public boolean isEnabled() {
        IEditingDomainProvider domainProvider;
        EditingDomain domain;
        Object adapter;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        TransactionalEditingDomain transactionalEditingDomain = null;
        if (editor != null && (adapter = editor.getAdapter(IEditingDomainProvider.class)) instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
            transactionalEditingDomain = (TransactionalEditingDomain)domain;
        }
        if (transactionalEditingDomain != null && this.isActiveModeling) {
            ResourceSet resourceSet = transactionalEditingDomain.getResourceSet();
            for (Resource resource : resourceSet.getResources()) {
                String resourceUri = resource.getURI().toString();
                String remoteUri = ChangeModelUtil.getRemoteModelUri(resourceUri);
                if (remoteUri == null) continue;
                return true;
            }
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.notificationListenerManager == null) {
            return null;
        }
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        if (!oldValue) {
            this.buttonPushed = true;
            this.notificationListenerManager.addNotificationListener((INotificationListener)this.modelbusChangeModelNotificationListener);
            this.prepareAllOpenEditorsForActiveModeling();
        } else {
            this.buttonPushed = false;
            this.removeAllListenersFromAllOpenEditors();
            this.notificationListenerManager.removeNotificationListener((INotificationListener)this.modelbusChangeModelNotificationListener);
        }
        return null;
    }

    private void prepareAllOpenEditorsForActiveModeling() {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditingDomainProvider domainProvider;
            EditingDomain domain;
            Object adapter;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(true);
            ResourceSet resourceSet = null;
            TransactionalEditingDomain transactionalEditingDomain = null;
            if (editorPart != null && (adapter = editorPart.getAdapter(IEditingDomainProvider.class)) instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                transactionalEditingDomain = (TransactionalEditingDomain)domain;
                resourceSet = transactionalEditingDomain.getResourceSet();
                this.modelbusChangeModelResourceSetListener.setTarget((Notifier)resourceSet);
                transactionalEditingDomain.addResourceSetListener((ResourceSetListener)this.modelbusChangeModelResourceSetListener);
                if (this.isCommitOnSave) {
                    this.prepareEditorForCommitOnSave(editorPart, transactionalEditingDomain);
                }
            }
            ++n2;
        }
        if (!this.isCommitOnSave) {
            this.prepareActiveEditorForImmediateCommit();
        }
    }

    private void prepareActiveEditorForImmediateCommit() {
        IEditingDomainProvider domainProvider;
        EditingDomain domain;
        Object adapter;
        IEditorPart activeEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditorPart != null && (adapter = activeEditorPart.getAdapter(IEditingDomainProvider.class)) instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
            URIEditorInput uriEditorInput;
            Object adapter2;
            IEditorInput input = activeEditorPart.getEditorInput();
            String remotePath = null;
            String localPath = null;
            if (input instanceof IPathEditorInput) {
                localPath = "file:/" + ((IPathEditorInput)input).getPath().toString();
            } else if (input instanceof IDiagramEditorInput) {
                IFile file = (IFile)((IDiagramEditorInput)input).getAdapter(IFile.class);
                if (file != null) {
                    localPath = "file:/" + file.getLocation().toString();
                }
            } else if (input instanceof URIEditorInput && (adapter2 = (uriEditorInput = (URIEditorInput)input).getAdapter(IFile.class)) != null) {
                IFile iFile = (IFile)adapter2;
                localPath = "file:/" + iFile.getLocation().toString();
            }
            if (localPath != null && (remotePath = ChangeModelUtil.getRemoteModelUri(localPath)) != null) {
                this.modelbusChangeModelResourceSetListener.setFileEditorInputPath(remotePath);
            }
        }
    }

    private void prepareEditorForCommitOnSave(IEditorPart editorPart, TransactionalEditingDomain transactionalEditingDomain) {
        ICommandService service = (ICommandService)editorPart.getEditorSite().getService(ICommandService.class);
        ModelBusExcecutionListener modelBusExcecutionListener = this.getExecutionListener(transactionalEditingDomain);
        if (modelBusExcecutionListener == null) {
            modelBusExcecutionListener = new ModelBusExcecutionListener(this.modelbusChangeModelResourceSetListener, transactionalEditingDomain);
            this.getExecutionListenerMap().put(transactionalEditingDomain, modelBusExcecutionListener);
            service.addExecutionListener((IExecutionListener)modelBusExcecutionListener);
        }
    }

    private ModelBusExcecutionListener getExecutionListener(TransactionalEditingDomain domain) {
        HashMap<TransactionalEditingDomain, ModelBusExcecutionListener> domainToExecutionListenerMap = this.getExecutionListenerMap();
        return domainToExecutionListenerMap.get(domain);
    }

    private HashMap<TransactionalEditingDomain, ModelBusExcecutionListener> getExecutionListenerMap() {
        if (this.domainToExecutionListenerMap == null) {
            this.domainToExecutionListenerMap = new HashMap();
        }
        return this.domainToExecutionListenerMap;
    }

    private void removeExecutionListenerFromAllEditors() {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditingDomainProvider domainProvider;
            EditingDomain domain;
            Object adapter;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(true);
            TransactionalEditingDomain transactionalEditingDomain = null;
            if (editorPart != null && (adapter = editorPart.getAdapter(IEditingDomainProvider.class)) instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                transactionalEditingDomain = (TransactionalEditingDomain)domain;
                this.removeExecutionListenerFromEditor(editorPart, transactionalEditingDomain);
            }
            ++n2;
        }
    }

    private void removeExecutionListenerFromEditor(IEditorPart editorPart, TransactionalEditingDomain transactionalEditingDomain) {
        ICommandService service = (ICommandService)editorPart.getEditorSite().getService(ICommandService.class);
        ModelBusExcecutionListener modelBusExcecutionListener = this.getExecutionListener(transactionalEditingDomain);
        if (modelBusExcecutionListener != null) {
            service.removeExecutionListener((IExecutionListener)modelBusExcecutionListener);
            this.getExecutionListenerMap().remove(transactionalEditingDomain);
        }
    }

    private void removeAllListenersFromAllOpenEditors() {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditingDomainProvider domainProvider;
            EditingDomain domain;
            Object adapter;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(true);
            ResourceSet resourceSet = null;
            TransactionalEditingDomain transactionalEditingDomain = null;
            if (editorPart != null && (adapter = editorPart.getAdapter(IEditingDomainProvider.class)) instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                transactionalEditingDomain = (TransactionalEditingDomain)domain;
                resourceSet = transactionalEditingDomain.getResourceSet();
                if (transactionalEditingDomain != null) {
                    this.modelbusChangeModelResourceSetListener.unsetTarget((Notifier)resourceSet);
                    transactionalEditingDomain.removeResourceSetListener((ResourceSetListener)this.modelbusChangeModelResourceSetListener);
                }
                if (this.isCommitOnSave) {
                    this.removeExecutionListenerFromEditor(editorPart, transactionalEditingDomain);
                }
            }
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("MODELBUS_automatic_update")) {
            this.isActiveModeling = (Boolean)event.getNewValue();
            if (!this.isActiveModeling) {
                this.removeAllListenersFromAllOpenEditors();
            } else {
                this.prepareAllOpenEditorsForActiveModeling();
            }
        } else if (event.getProperty().equals("MODELBUS_commit_on_save")) {
            this.isCommitOnSave = (Boolean)event.getNewValue();
            if (this.isCommitOnSave) {
                this.prepareAllEditorsForCommitOnSave();
            } else {
                this.removeExecutionListenerFromAllEditors();
            }
        }
    }

    private void prepareAllEditorsForCommitOnSave() {
        IEditorReference[] editorReferences;
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditingDomainProvider domainProvider;
            EditingDomain domain;
            Object adapter;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(true);
            TransactionalEditingDomain transactionalEditingDomain = null;
            if (editorPart != null && (adapter = editorPart.getAdapter(IEditingDomainProvider.class)) instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                transactionalEditingDomain = (TransactionalEditingDomain)domain;
                this.prepareEditorForCommitOnSave(editorPart, transactionalEditingDomain);
            }
            ++n2;
        }
    }

    public void partActivated(IWorkbenchPart part) {
        IEditingDomainProvider domainProvider;
        EditingDomain domain;
        IEditorPart editorPart;
        Object adapter;
        if (part instanceof IEditorPart && this.buttonPushed && !this.isCommitOnSave && (adapter = (editorPart = (IEditorPart)part).getAdapter(IEditingDomainProvider.class)) instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
            String localPath;
            IEditorInput input = editorPart.getEditorInput();
            String remotePath = null;
            if (input instanceof IFileEditorInput && (remotePath = ChangeModelUtil.getRemoteModelUri(localPath = "file:/" + ((IFileEditorInput)input).getFile().getLocation().toString())) != null) {
                this.modelbusChangeModelResourceSetListener.setFileEditorInputPath(remotePath);
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart && this.buttonPushed) {
            IEditingDomainProvider domainProvider;
            EditingDomain domain;
            TransactionalEditingDomain transactionalEditingDomain = null;
            ResourceSet resourceSet = null;
            Object adapter = part.getAdapter(IEditingDomainProvider.class);
            if (adapter instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                transactionalEditingDomain = (TransactionalEditingDomain)domain;
                resourceSet = transactionalEditingDomain.getResourceSet();
                this.modelbusChangeModelResourceSetListener.unsetTarget((Notifier)resourceSet);
                transactionalEditingDomain.removeResourceSetListener((ResourceSetListener)this.modelbusChangeModelResourceSetListener);
            }
            this.removeExecutionListenerFromEditor((IEditorPart)part, transactionalEditingDomain);
        }
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart && this.buttonPushed) {
            IEditingDomainProvider domainProvider;
            EditingDomain domain;
            TransactionalEditingDomain transactionalEditingDomain = null;
            ResourceSet resourceSet = null;
            Object adapter = part.getAdapter(IEditingDomainProvider.class);
            if (adapter instanceof IEditingDomainProvider && (domain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                transactionalEditingDomain = (TransactionalEditingDomain)domain;
                resourceSet = transactionalEditingDomain.getResourceSet();
                this.modelbusChangeModelResourceSetListener.setTarget((Notifier)resourceSet);
                transactionalEditingDomain.addResourceSetListener((ResourceSetListener)this.modelbusChangeModelResourceSetListener);
            }
            if (this.isCommitOnSave) {
                this.prepareEditorForCommitOnSave((IEditorPart)part, transactionalEditingDomain);
            }
        }
    }

    protected String getRepositoryLocation() {
        if (this.repositoryLocation == null) {
            this.repositoryLocation = RepositoryLocationHelper.getPropertyRepositoryLocation();
        }
        return this.repositoryLocation;
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }
}

