/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.changemodelnotification.commit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.team.eclipse.changemodelnotification.commit.ModelBusChangeManager;
import org.modelbus.team.eclipse.changemodelnotification.util.ChangeModelUtil;

public class ModelBusChangeRecorderConverter {
    private TransactionalEditingDomain domain;
    private List<Notification> recordedNotifications;
    private Map<EObject, String> eObjetToIDMap;
    private EcoreUtil.Copier copier;
    private Map<Resource, String> resourceToUriMap;
    private ChangeDescription changeDescription;
    private List<EObject> objectsToAttach;
    private Map<FeatureChange, EList<Object>> featureChangeToOldValueMap;

    public ModelBusChangeRecorderConverter(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    private ChangeDescription getChangeDescription() {
        if (this.changeDescription == null) {
            this.changeDescription = ChangeFactory.eINSTANCE.createChangeDescription();
        }
        return this.changeDescription;
    }

    private List<EObject> getObjectsToAttach() {
        if (this.objectsToAttach == null) {
            this.objectsToAttach = new ArrayList<EObject>();
        }
        return this.objectsToAttach;
    }

    private Map<FeatureChange, EList<Object>> getFeatureChangeToOldValueMap() {
        if (this.featureChangeToOldValueMap == null) {
            this.featureChangeToOldValueMap = new HashMap<FeatureChange, EList<Object>>();
        }
        return this.featureChangeToOldValueMap;
    }

    private EcoreUtil.Copier getCopier() {
        if (this.copier == null) {
            this.copier = new EcoreUtil.Copier();
        }
        return this.copier;
    }

    private EObject copy(EObject eObject) {
        EcoreUtil.Copier copier = this.getCopier();
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        return result;
    }

    public List<Notification> getRecordedNotifications() {
        if (this.recordedNotifications == null) {
            this.recordedNotifications = new ArrayList<Notification>();
        }
        return this.recordedNotifications;
    }

    private Map<EObject, String> getEObjectToIDMap() {
        if (this.eObjetToIDMap == null) {
            this.eObjetToIDMap = new HashMap<EObject, String>();
        }
        return this.eObjetToIDMap;
    }

    public void recordNotification(Notification notification) {
        Object newValue = notification.getNewValue();
        Object feature = notification.getFeature();
        Object object = notification.getNotifier();
        if (object instanceof EObject) {
            EObject notifier = (EObject)object;
            if (!this.isContainedInTransientFeature(notifier) && !((EStructuralFeature)feature).isTransient()) {
                if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                    if (newValue instanceof EObject) {
                        this.copy((EObject)newValue);
                    } else if (newValue instanceof EList) {
                        for (Object obj : (EList)newValue) {
                            if (!(obj instanceof EObject)) continue;
                            this.copy((EObject)obj);
                        }
                    }
                }
                this.getRecordedNotifications().add(notification);
            }
        } else if (object instanceof Resource) {
            if (notification.getEventType() == 3 && newValue instanceof EObject) {
                this.copy((EObject)newValue);
            }
            this.getRecordedNotifications().add(notification);
        }
    }

    private boolean isContainedInTransientFeature(EObject eObject) {
        EObject container = eObject.eContainer();
        while (container != null) {
            EStructuralFeature containingFeature = eObject.eContainingFeature();
            if (containingFeature.isTransient()) {
                return true;
            }
            eObject = container;
            container = eObject.eContainer();
        }
        return false;
    }

    public List<Notification> stopRecordNotifications() {
        List<Notification> notifications = this.getRecordedNotifications();
        this.recordedNotifications = null;
        return notifications;
    }

    private EObject getCopy(EObject eObject) {
        EcoreUtil.Copier copier = this.getCopier();
        if (copier.containsKey((Object)eObject)) {
            return (EObject)copier.get((Object)eObject);
        }
        return null;
    }

    private EObject getContainerCopy(EObject eObject) {
        EcoreUtil.Copier copier = this.getCopier();
        EObject container = eObject.eContainer();
        while (container != null) {
            if (copier.containsKey((Object)container)) {
                return (EObject)copier.get((Object)container);
            }
            container = container.eContainer();
        }
        return null;
    }

    public ChangeDescription convertNotificationsToChangeDescription(List<Notification> notifications) {
        ChangeDescription changeDescription = null;
        try {
            for (Notification notification : notifications) {
                String remoteUri;
                Object notifier = notification.getNotifier();
                if (notifier instanceof EObject) {
                    Object feature;
                    String localUri = null;
                    Resource eObjectResource = ((EObject)notifier).eResource();
                    if (eObjectResource != null && !ModelBusCoreUtil.URIUtil.isHTTPURI((String)(localUri = eObjectResource.getURI().toString())) && (remoteUri = ChangeModelUtil.getRemoteModelUri(localUri)) != null) {
                        eObjectResource.setURI(URI.createURI((String)remoteUri));
                        this.getResource2LocalUriMap().put(eObjectResource, localUri);
                    }
                    if (!((feature = notification.getFeature()) instanceof EStructuralFeature)) continue;
                    this.handleFeatureChange((EStructuralFeature)feature, notification);
                    continue;
                }
                if (!(notifier instanceof Resource)) continue;
                Resource resource = (Resource)notifier;
                String resourceURI = resource.getURI().toString();
                if (!ModelBusCoreUtil.URIUtil.isHTTPURI((String)resourceURI) && (remoteUri = ChangeModelUtil.getRemoteModelUri(resourceURI)) != null) {
                    resource.setURI(URI.createURI((String)remoteUri));
                    this.getResource2LocalUriMap().put(resource, resourceURI);
                }
                this.handleResourceChange(notification);
            }
            changeDescription = this.getChangeDescription();
        }
        finally {
            ModelBusChangeManager.getDomainToChangeManagerMap().remove(this.domain);
        }
        return changeDescription;
    }

    private void createListChanges(EList<Object> newList, EList<?> oldList, EList<ListChange> listChanges) {
        int index = 0;
        for (Object oldObject : oldList) {
            if (newList.size() <= index) {
                ListChange listChange = this.createREMOVEListChange(index);
                listChanges.add((Object)listChange);
            } else {
                boolean done;
                do {
                    done = true;
                    Object targetObject = newList.get(index);
                    if (!(targetObject == null ? oldObject != null : !targetObject.equals(oldObject))) continue;
                    int position = ECollections.indexOf(newList, oldObject, (int)index);
                    if (position != -1) {
                        ListChange listChange;
                        int targetIndex = ECollections.indexOf(oldList, (Object)targetObject, (int)index);
                        if (targetIndex == -1) {
                            listChange = this.createADDListChange(index, targetObject);
                            listChanges.add((Object)listChange);
                            newList.remove(index);
                            done = false;
                            continue;
                        }
                        if (position > targetIndex) {
                            if (newList.size() <= position) {
                                position = newList.size() - 1;
                            }
                            listChange = this.createMOVEListChange(index, position);
                            listChanges.add((Object)listChange);
                            newList.move(index, position);
                            done = false;
                            continue;
                        }
                        if (index == targetIndex) continue;
                        listChange = this.createMOVEListChange(index, targetIndex);
                        listChanges.add((Object)listChange);
                        continue;
                    }
                    ListChange listChange = this.createREMOVEListChange(index);
                    listChanges.add((Object)listChange);
                    newList.add(index, oldList.get(index));
                    done = false;
                } while (!done);
            }
            ++index;
        }
        int i = newList.size();
        while (i > index) {
            Object object;
            int ind;
            if ((ind = oldList.indexOf(object = newList.get(--i))) != -1) continue;
            ListChange listChange = this.createADDListChange(i, newList.get(i));
            listChanges.add((Object)listChange);
        }
    }

    public Map<Resource, String> getResource2LocalUriMap() {
        if (this.resourceToUriMap == null) {
            this.resourceToUriMap = new HashMap<Resource, String>();
        }
        return this.resourceToUriMap;
    }

    private void adjustObjectChanges(ChangeDescription changeDescription) {
        EList objectsToattach = changeDescription.getObjectsToAttach();
        EMap objectChanges = changeDescription.getObjectChanges();
        BasicEMap changedObjectChanges = new BasicEMap(objectChanges.map());
        for (Map.Entry entry : objectChanges) {
            EObject key = (EObject)entry.getKey();
            EList featureChangeValue = (EList)entry.getValue();
            if (!objectsToattach.contains((Object)key)) continue;
            for (Map.Entry entry2 : objectChanges) {
                EObject key2 = (EObject)entry2.getKey();
                if (key.equals(key2)) continue;
                EList featureChanges = (EList)entry2.getValue();
                for (FeatureChange featureChange : featureChanges) {
                    EList listChanges = featureChange.getListChanges();
                    block3: for (ListChange listChange : listChanges) {
                        EList referenceValues = listChange.getReferenceValues();
                        for (EObject value : referenceValues) {
                            if (!key.equals(value)) continue;
                            EObject newKey = EcoreUtil.copy((EObject)key);
                            String fragment = EcoreUtil.getURI((EObject)key).fragment();
                            URI resourceuri = EcoreUtil.getURI((EObject)key2).trimFragment();
                            if (resourceuri == null || resourceuri.toString().isEmpty() || resourceuri.toString().equals("tempResource")) continue;
                            URI uri = resourceuri.appendFragment(fragment);
                            ((InternalEObject)newKey).eSetProxyURI(uri);
                            changedObjectChanges.removeKey((Object)key);
                            changedObjectChanges.put((Object)newKey, (Object)featureChangeValue);
                            continue block3;
                        }
                    }
                }
            }
        }
        objectChanges.clear();
        objectChanges.putAll((EMap)changedObjectChanges);
    }

    private void setIDs(Resource tempResource, ChangeDescription changeDescription) {
        EList objectsToattach = changeDescription.getObjectsToAttach();
        for (EObject objectToAttach : objectsToattach) {
            Map<EObject, String> objectToIDMap = this.getEObjectToIDMap();
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)objectToAttach, (boolean)true);
            while (iterator.hasNext()) {
                EObject contentObject = (EObject)iterator.next();
                String id = objectToIDMap.get(contentObject);
                if (id == null) continue;
                ((XMIResource)tempResource).setID(contentObject, id);
            }
            String objectID = objectToIDMap.get(objectToAttach);
            if (objectID == null) continue;
            ((XMIResource)tempResource).setID(objectToAttach, objectID);
        }
    }

    public String eObjectToString(EObject eObject) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource tempResource = resourceSet.createResource(URI.createURI((String)"tempResource"));
        tempResource.getContents().add((Object)eObject);
        this.setIDs(tempResource, (ChangeDescription)eObject);
        this.adjustObjectChanges((ChangeDescription)eObject);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            tempResource.save((OutputStream)output, Collections.EMPTY_MAP);
            System.out.println("ChangeRecorder: ChangeDescription: " + output.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    private EList<FeatureChange> getFeatureChanges(EObject eObject) {
        EList changes;
        Resource resource = eObject.eResource();
        String fragment = EcoreUtil.getURI((EObject)eObject).fragment();
        String id = ((XMIResource)resource).getID(eObject);
        ChangeDescription changeDescription = this.getChangeDescription();
        EObject copy = this.getCopy(eObject);
        if (copy != null && !this.getObjectsToAttach().contains(copy)) {
            eObject = copy;
        }
        if ((changes = (EList)changeDescription.getObjectChanges().get((Object)eObject)) == null) {
            if (!(id != null || fragment == null || fragment.equals("/") || fragment.startsWith("//@") && fragment.charAt(fragment.lastIndexOf("/") + 1) == '@')) {
                EObject copyEObject = this.copy(eObject);
                this.handleUri(eObject, copyEObject);
                eObject = copyEObject;
            }
            Map.Entry entry = ChangeFactory.eINSTANCE.createEObjectToChangesMapEntry(eObject);
            changeDescription.getObjectChanges().add((Object)entry);
            changes = (EList)entry.getValue();
        }
        return changes;
    }

    private void handleObjectToAttach(EObject eObject) {
        Map crossReferencesMap = EcoreUtil.CrossReferencer.find(Collections.singletonList(eObject));
        for (Map.Entry entry : crossReferencesMap.entrySet()) {
            String remoteUri;
            String localUri;
            EObject key = (EObject)entry.getKey();
            Resource resource = key.eResource();
            if (resource == null || ModelBusCoreUtil.URIUtil.isHTTPURI((String)(localUri = resource.getURI().toString())) || (remoteUri = ChangeModelUtil.getRemoteModelUri(localUri)) == null) continue;
            resource.setURI(URI.createURI((String)remoteUri));
            this.getResource2LocalUriMap().put(resource, localUri);
        }
    }

    private void handleUri(EObject eobject, EObject copyObject) {
        URI uri = eobject.eResource().getURI();
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = eobject.eContainer();
        while (container != null) {
            EStructuralFeature containingFeature = eobject.eContainingFeature();
            String uriFragment = this.getURIFragment(containingFeature, eobject);
            if (uriFragment.isEmpty()) {
                uriFragmentPath.clear();
                break;
            }
            uriFragmentPath.add(uriFragment);
            eobject = container;
            container = eobject.eContainer();
        }
        if (!uriFragmentPath.isEmpty()) {
            StringBuilder resultFragmentPath = new StringBuilder();
            resultFragmentPath.append("/");
            int i = uriFragmentPath.size() - 1;
            while (i >= 0) {
                resultFragmentPath.append("/");
                resultFragmentPath.append((String)uriFragmentPath.get(i));
                --i;
            }
            String fragment = resultFragmentPath.toString();
            ((InternalEObject)copyObject).eSetProxyURI(uri.appendFragment(fragment));
        } else {
            ((InternalEObject)copyObject).eSetProxyURI(EcoreUtil.getURI((EObject)eobject));
        }
    }

    private String getURIFragment(EStructuralFeature feature, EObject eObject) {
        EObject container = eObject.eContainer();
        StringBuilder result = new StringBuilder();
        result.append('@');
        result.append(feature.getName());
        if (feature instanceof EReference && feature.isMany()) {
            result.append(".");
            EList featureValue = (EList)container.eGet(feature);
            int index = featureValue.indexOf((Object)eObject);
            result.append(index);
        }
        return result.toString();
    }

    private void handleCopy(EObject notifier, Notification notification) {
        EObject copiedObject = this.getCopy(notifier);
        EObject copiedContainer = this.getContainerCopy(notifier);
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (copiedObject != null) {
            if (!feature.isUnsettable() && copiedObject.eIsSet(feature)) {
                copiedObject.eUnset(feature);
            }
        } else if (copiedContainer != null) {
            EObject notifierInCopiedObject = null;
            EStructuralFeature containingFeature = notifier.eContainingFeature();
            EObject originalContainer = notifier.eContainer();
            Object featureValue = originalContainer.eGet(containingFeature);
            if (copiedContainer.eIsSet(containingFeature)) {
                int index = -1;
                if (featureValue instanceof List) {
                    index = ((List)featureValue).indexOf(notifier);
                }
                if ((notifierInCopiedObject = index == -1 ? (EObject)copiedContainer.eGet(containingFeature) : (EObject)((List)copiedContainer.eGet(containingFeature)).get(index)) != null) {
                    notifierInCopiedObject.eUnset(feature);
                }
            } else {
                EObject notifierCopy = this.copy(notifier);
                if (!feature.isUnsettable()) {
                    notifierCopy.eUnset(feature);
                }
                Object newValue = notifierCopy;
                if (feature.isMany()) {
                    newValue = Collections.singletonList(notifierCopy);
                }
                copiedContainer.eSet(containingFeature, newValue);
            }
        }
    }

    private EList<ResourceChange> getResourceChanges() {
        return this.getChangeDescription().getResourceChanges();
    }

    private ResourceChange getResourceChange(Resource resource) {
        EList<ResourceChange> resourceChanges = this.getResourceChanges();
        int i = 0;
        while (i < resourceChanges.size()) {
            ResourceChange resourceChange = (ResourceChange)resourceChanges.get(i);
            if (resourceChange.getResource() == resource) {
                return resourceChange;
            }
            ++i;
        }
        return null;
    }

    private FeatureChange getFeatureChange(List<FeatureChange> changes, EStructuralFeature feature) {
        for (FeatureChange featureChange : changes) {
            if (featureChange.getFeature() != feature) continue;
            return featureChange;
        }
        return null;
    }

    private void handleResourceChange(Notification notification) {
        Resource resource = (Resource)notification.getNotifier();
        ResourceChange resourceChange = this.getResourceChange(resource);
        EList<ResourceChange> resourceChanges = this.getResourceChanges();
        Object notificationNewValue = notification.getNewValue();
        int position = notification.getPosition();
        switch (notification.getEventType()) {
            case 3: {
                if (resource == null || resourceChanges == null) break;
                BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                BasicEList newList = new BasicEList((Collection)resource.getContents());
                oldValue.remove(position);
                if (resourceChange != null) {
                    oldValue = new BasicEList((Collection)resourceChange.getValue());
                    oldValue.remove(notificationNewValue);
                    resourceChanges.remove(resourceChange);
                }
                resourceChange = ChangeFactory.eINSTANCE.createResourceChange(resource, (EList)oldValue);
                resourceChanges.add(resourceChange);
                EList listChanges = resourceChange.getListChanges();
                listChanges.clear();
                this.createListChanges((EList<Object>)newList, (EList<?>)oldValue, (EList<ListChange>)listChanges);
                break;
            }
            case 4: {
                if (resource == null || resourceChanges == null) break;
                BasicEList oldValue = new BasicEList((Collection)resource.getContents());
                BasicEList newList = new BasicEList((Collection)resource.getContents());
                if (position == -1) {
                    position = 0;
                }
                if (resourceChange != null) {
                    oldValue = new BasicEList((Collection)resourceChange.getValue());
                    resourceChanges.remove(resourceChange);
                }
                if (position <= oldValue.size()) {
                    oldValue.add(position, notification.getOldValue());
                } else {
                    oldValue.add(notification.getOldValue());
                }
                resourceChange = ChangeFactory.eINSTANCE.createResourceChange(resource, (EList)oldValue);
                resourceChanges.add(resourceChange);
                EList listChanges = resourceChange.getListChanges();
                listChanges.clear();
                this.createListChanges((EList<Object>)newList, (EList<?>)oldValue, (EList<ListChange>)listChanges);
            }
        }
    }

    private void handleFeatureChange(EStructuralFeature feature, Notification notification) {
        EObject notifier = (EObject)notification.getNotifier();
        int position = notification.getPosition();
        Object notificationNewValue = notification.getNewValue();
        Object newValue = null;
        Resource notifierResource = notifier.eResource();
        if (notifierResource == null) {
            return;
        }
        this.handleCopy(notifier, notification);
        EList<FeatureChange> changes = this.getFeatureChanges(notifier);
        FeatureChange change = this.getFeatureChange((List<FeatureChange>)changes, feature);
        boolean set = notification.wasSet();
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                String remoteUri;
                String localUri;
                Resource resource;
                EObject referenceValue;
                if (change != null && changes != null) {
                    changes.remove((Object)change);
                }
                if (changes != null) {
                    EObject newEObject = null;
                    if (feature.isMany()) {
                        newValue = new BasicEList((Collection)notifier.eGet(feature));
                        Object newValueObject = ((EList)newValue).get(position);
                        if (newValueObject instanceof EObject) {
                            newEObject = (EObject)newValueObject;
                        }
                    } else {
                        newValue = notificationNewValue;
                        if (newValue instanceof EObject) {
                            newEObject = (EObject)newValue;
                        }
                    }
                    if (newEObject != null && notifier.equals(newEObject.eContainer())) {
                        List<EObject> objectsToAttach;
                        EcoreUtil.Copier copier = this.getCopier();
                        EObject newEObjectCopy = (EObject)copier.get((Object)newEObject);
                        if (newEObjectCopy == null) {
                            newEObjectCopy = this.copy(newEObject);
                        }
                        if (!(objectsToAttach = this.getObjectsToAttach()).contains(newEObjectCopy)) {
                            this.handleObjectToAttach(newEObjectCopy);
                            this.fillEObjectToIDMap(Collections.singletonList(newEObject), Collections.singletonList(newEObjectCopy));
                            objectsToAttach.add(newEObjectCopy);
                            ChangeDescription changeDescription = this.getChangeDescription();
                            ((ChangeDescriptionImpl)changeDescription).eSet(2, objectsToAttach);
                        }
                        if (newValue instanceof EList) {
                            ((EList)newValue).remove(position);
                            ((EList)newValue).add(position, (Object)newEObjectCopy);
                        } else {
                            newValue = newEObjectCopy;
                        }
                    }
                }
                if ((referenceValue = (change = this.createFeatureChange(feature, newValue, set)).getReferenceValue()) != null && (resource = referenceValue.eResource()) != null && !ModelBusCoreUtil.URIUtil.isHTTPURI((String)(localUri = resource.getURI().toString())) && (remoteUri = ChangeModelUtil.getRemoteModelUri(localUri)) != null) {
                    resource.setURI(URI.createURI((String)remoteUri));
                    this.getResource2LocalUriMap().put(resource, localUri);
                }
                changes.add((Object)change);
                break;
            }
            case 4: {
                if (changes == null) break;
                BasicEList oldValue = new BasicEList((Collection)notifier.eGet(feature));
                BasicEList newList = new BasicEList((Collection)notifier.eGet(feature));
                if (position == -1) {
                    position = 0;
                }
                if (change != null) {
                    oldValue = new BasicEList((Collection)this.getFeatureChangeToOldValueMap().get(change));
                }
                if (position <= oldValue.size()) {
                    oldValue.add(position, notification.getOldValue());
                } else {
                    oldValue.add(notification.getOldValue());
                }
                if (change == null) {
                    change = this.createFeatureChange(feature, newValue, set);
                }
                this.getFeatureChangeToOldValueMap().put(change, (EList<Object>)oldValue);
                changes.add((Object)change);
                EList listChanges = change.getListChanges();
                listChanges.clear();
                this.createListChanges((EList<Object>)newList, (EList<?>)oldValue, (EList<ListChange>)listChanges);
                break;
            }
            case 6: {
                int[] positions;
                if (changes == null) break;
                List removedValues = (List)notification.getOldValue();
                BasicEList oldValue = new BasicEList((Collection)notifier.eGet(feature));
                BasicEList newList = new BasicEList((Collection)notifier.eGet(feature));
                if (change != null) {
                    oldValue = new BasicEList((Collection)this.getFeatureChangeToOldValueMap().get(change));
                }
                if ((positions = (int[])notification.getNewValue()) == null) {
                    oldValue.addAll((Collection)removedValues);
                } else {
                    int i = 0;
                    while (i < positions.length) {
                        oldValue.add(positions[i], removedValues.get(i));
                        ++i;
                    }
                }
                if (change == null) {
                    change = this.createFeatureChange(feature, newValue, set);
                }
                this.getFeatureChangeToOldValueMap().put(change, (EList<Object>)oldValue);
                changes.add((Object)change);
                EList listChanges = change.getListChanges();
                listChanges.clear();
                this.createListChanges((EList<Object>)newList, (EList<?>)oldValue, (EList<ListChange>)listChanges);
                break;
            }
            case 5: {
                EList listChanges;
                String remoteUri;
                String localUri;
                Resource resource;
                EObject referenceValue;
                BasicEList newList;
                BasicEList oldValue;
                if (changes != null) {
                    oldValue = new BasicEList((Collection)notifier.eGet(feature));
                    newList = new BasicEList((Collection)notifier.eGet(feature));
                    int i = ((Collection)notification.getNewValue()).size();
                    while (--i >= 0) {
                        oldValue.remove(position);
                    }
                    if (change != null) {
                        oldValue = new BasicEList((Collection)this.getFeatureChangeToOldValueMap().get(change));
                        oldValue.removeAll((Collection)notification.getNewValue());
                    }
                    if (change == null) {
                        change = this.createFeatureChange(feature, newValue, set);
                    }
                    this.getFeatureChangeToOldValueMap().put(change, (EList<Object>)oldValue);
                    referenceValue = change.getReferenceValue();
                    if (referenceValue != null && (resource = referenceValue.eResource()) != null && !ModelBusCoreUtil.URIUtil.isHTTPURI((String)(localUri = resource.getURI().toString())) && (remoteUri = ChangeModelUtil.getRemoteModelUri(localUri)) != null) {
                        resource.setURI(URI.createURI((String)remoteUri));
                        this.getResource2LocalUriMap().put(resource, localUri);
                    }
                    changes.add((Object)change);
                    listChanges = change.getListChanges();
                    listChanges.clear();
                    this.createListChanges((EList<Object>)newList, (EList<?>)oldValue, (EList<ListChange>)listChanges);
                }
            }
            case 3: {
                String remoteUri;
                String localUri;
                Resource resource;
                if (changes == null) break;
                BasicEList oldValue = new BasicEList((Collection)notifier.eGet(feature));
                BasicEList newList = new BasicEList((Collection)notifier.eGet(feature));
                if (position >= oldValue.size()) {
                    position = oldValue.size() - 1;
                }
                oldValue.remove(position);
                if (change != null) {
                    oldValue = new BasicEList((Collection)this.getFeatureChangeToOldValueMap().get(change));
                    oldValue.remove(notification.getNewValue());
                }
                if (change == null) {
                    change = this.createFeatureChange(feature, newValue, set);
                }
                this.getFeatureChangeToOldValueMap().put(change, (EList<Object>)oldValue);
                EObject referenceValue = change.getReferenceValue();
                if (referenceValue != null && (resource = referenceValue.eResource()) != null && !ModelBusCoreUtil.URIUtil.isHTTPURI((String)(localUri = resource.getURI().toString())) && (remoteUri = ChangeModelUtil.getRemoteModelUri(localUri)) != null) {
                    resource.setURI(URI.createURI((String)remoteUri));
                    this.getResource2LocalUriMap().put(resource, localUri);
                }
                changes.add((Object)change);
                EList listChanges = change.getListChanges();
                listChanges.clear();
                this.createListChanges((EList<Object>)newList, (EList<?>)oldValue, (EList<ListChange>)listChanges);
                break;
            }
            case 7: {
                if (changes == null) break;
                BasicEList oldValue = new BasicEList((Collection)notifier.eGet(feature));
                BasicEList newList = new BasicEList((Collection)notifier.eGet(feature));
                int oldPosition = (Integer)notification.getOldValue();
                int newPosition = position;
                Object movedObject = oldValue.get(newPosition);
                oldValue.move(oldPosition, newPosition);
                if (change != null) {
                    oldValue = new BasicEList((Collection)this.getFeatureChangeToOldValueMap().get(change));
                    oldValue.move(oldPosition, movedObject);
                }
                if (change == null) {
                    change = this.createFeatureChange(feature, newValue, set);
                }
                this.getFeatureChangeToOldValueMap().put(change, (EList<Object>)oldValue);
                changes.add((Object)change);
                EList listChanges = change.getListChanges();
                listChanges.clear();
                this.createListChanges((EList<Object>)newList, (EList<?>)oldValue, (EList<ListChange>)listChanges);
                break;
            }
        }
    }

    private ListChange createREMOVEListChange(int index) {
        ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
        listChange.setIndex(index);
        listChange.setKind(ChangeKind.REMOVE_LITERAL);
        return listChange;
    }

    private ListChange createMOVEListChange(int index, int moveToIndex) {
        ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
        listChange.setIndex(index);
        listChange.setMoveToIndex(moveToIndex);
        listChange.setKind(ChangeKind.MOVE_LITERAL);
        return listChange;
    }

    private void fillEObjectToIDMap(List<?> original, List<?> copyObject) {
        EcoreUtil.Copier copier = this.getCopier();
        for (Object object : original) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            Resource resource = eObject.eResource();
            String eObjectID = null;
            if (resource != null) {
                eObjectID = ((XMIResource)eObject.eResource()).getID(eObject);
                TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)true);
                while (iterator.hasNext()) {
                    EObject contentObject = (EObject)iterator.next();
                    EObject contentCopyObject = (EObject)copier.get((Object)contentObject);
                    String id = ((XMIResource)contentObject.eResource()).getID(contentObject);
                    if (id == null) continue;
                    this.getEObjectToIDMap().put(contentCopyObject, id);
                }
            }
            if (eObjectID == null) continue;
            int position = original.indexOf(eObject);
            this.getEObjectToIDMap().put((EObject)copyObject.get(position), eObjectID);
        }
    }

    private ListChange createADDListChange(int index, Object newValue) {
        EcoreUtil.Copier copier = this.getCopier();
        BasicEList copyObject = new BasicEList();
        BasicEList originalObject = new BasicEList();
        if (newValue instanceof EObject) {
            EObject copy = (EObject)copier.get(newValue);
            if (copy != null) {
                originalObject.add((Object)((EObject)newValue));
                copyObject.add((Object)copy);
            }
        } else if (newValue instanceof Collection) {
            for (Object obj : (Collection)newValue) {
                if (obj instanceof EObject) {
                    EObject copy = (EObject)copier.get(obj);
                    copyObject.add((Object)copy);
                } else {
                    copyObject.add(obj);
                }
                originalObject.add(obj);
            }
        }
        this.fillEObjectToIDMap((List<?>)originalObject, (List<?>)copyObject);
        List<EObject> objectsToAttach = this.getObjectsToAttach();
        ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
        ChangeDescription changeDescription = this.getChangeDescription();
        for (Object object : copyObject) {
            EObject copyEObject;
            if (!(object instanceof EObject) || objectsToAttach.contains(copyEObject = (EObject)object)) continue;
            this.handleObjectToAttach(copyEObject);
            objectsToAttach.add(copyEObject);
            ((ChangeDescriptionImpl)changeDescription).eSet(2, objectsToAttach);
        }
        listChange.getValues().addAll((Collection)copyObject);
        listChange.setIndex(index);
        listChange.setKind(ChangeKind.ADD_LITERAL);
        return listChange;
    }

    private FeatureChange createFeatureChange(EStructuralFeature feature, Object value, boolean wasSet) {
        FeatureChange featureChange = null;
        if (value != null) {
            featureChange = ChangeFactory.eINSTANCE.createFeatureChange(feature, value, wasSet);
        } else {
            featureChange = ChangeFactory.eINSTANCE.createFeatureChange();
            featureChange.setFeature(feature);
        }
        return featureChange;
    }
}

