/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.changemodelnotification.update;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.modelbus.team.eclipse.changemodelnotification.util.ChangeModelUtil;
import org.modelbus.team.eclipse.core.ModelBusUriConverter;

public class UpdateManager {
    private TransactionalEditingDomain domain;
    private static UpdateManager updateManager;
    private IDiagramGraphicalViewer viewer;

    private UpdateManager() {
    }

    public static UpdateManager getUpdateManager() {
        if (updateManager == null) {
            updateManager = new UpdateManager();
        }
        return updateManager;
    }

    public synchronized void applyChanges(String changeModelDescription, String fileEditorInputPath) {
        System.out.println("UpdateManager ChangeDescription: " + changeModelDescription);
        ModelBusUriConverter modelBusUriConverter = new ModelBusUriConverter();
        this.setEditingDomainOfResourceToChange(fileEditorInputPath);
        if (this.domain == null) {
            return;
        }
        ResourceSet domainResourceSet = this.domain.getResourceSet();
        domainResourceSet.setURIConverter((URIConverter)modelBusUriConverter);
        ChangeDescription changeDescription = ChangeModelUtil.stringToEObject(changeModelDescription, domainResourceSet);
        this.modifyModel(changeDescription);
    }

    private void executeSETCommand(TransactionalEditingDomain domain, final EObject eObject, final EStructuralFeature feature, final Object newValue) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        options.put("modelbus_update", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                eObject.eSet(feature, newValue);
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void executeADDListChangeCommand(TransactionalEditingDomain domain, final EList<Object> oldList, final int index, final EList<Object> newValue) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        options.put("modelbus_update", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (index < 0 || index >= oldList.size()) {
                    oldList.addAll((Collection)newValue);
                } else {
                    oldList.addAll(index, (Collection)newValue);
                }
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void executeREMOVEListChangeCommand(TransactionalEditingDomain domain, final EList<Object> oldList, final int index) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        options.put("modelbus_update", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (!oldList.isEmpty()) {
                    if (index > -1 && index < oldList.size()) {
                        oldList.remove(index);
                    } else {
                        oldList.remove(oldList.size() - 1);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void executeMOVEListChangeCommand(TransactionalEditingDomain domain, final EList<Object> oldList, final int index, final int moveToIndex) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("no_undo", Boolean.TRUE);
        options.put("unprotected", Boolean.TRUE);
        options.put("modelbus_update", Boolean.TRUE);
        AbstractEMFOperation operation = new AbstractEMFOperation(domain, "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (moveToIndex < oldList.size()) {
                    oldList.move(moveToIndex, index);
                }
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setEditingDomainOfResourceToChange(final String fileEditorInputPath) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] editorReferences;
                IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    try {
                        URIEditorInput uriEditorInput;
                        Object adapter2;
                        IEditorInput input = editorReference.getEditorInput();
                        String remotePath = null;
                        String localPath = null;
                        if (input instanceof IPathEditorInput) {
                            localPath = "file:/" + ((IPathEditorInput)input).getPath().toString();
                        } else if (input instanceof IDiagramEditorInput) {
                            IFile file = (IFile)((IDiagramEditorInput)input).getAdapter(IFile.class);
                            if (file != null) {
                                localPath = "file:/" + file.getLocation().toString();
                            }
                        } else if (input instanceof URIEditorInput && (adapter2 = (uriEditorInput = (URIEditorInput)input).getAdapter(IFile.class)) != null) {
                            IFile iFile = (IFile)adapter2;
                            localPath = "file:/" + iFile.getLocation().toString();
                        }
                        if (localPath != null) {
                            IEditingDomainProvider domainProvider;
                            EditingDomain editingDomain;
                            Object adapter;
                            IEditorPart part;
                            remotePath = ChangeModelUtil.getRemoteModelUri(localPath);
                            if (fileEditorInputPath.equals(remotePath)) {
                                part = editorReference.getEditor(true);
                                if (part != null) {
                                    UpdateManager.this.viewer = ((IDiagramWorkbenchPart)part).getDiagramGraphicalViewer();
                                    adapter = part.getAdapter(IEditingDomainProvider.class);
                                    if (adapter instanceof IEditingDomainProvider && (editingDomain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                                        UpdateManager.this.domain = (TransactionalEditingDomain)editingDomain;
                                        break;
                                    }
                                }
                            } else {
                                part = editorReference.getEditor(true);
                                if (part != null) {
                                    UpdateManager.this.viewer = ((IDiagramWorkbenchPart)part).getDiagramGraphicalViewer();
                                    adapter = part.getAdapter(IEditingDomainProvider.class);
                                    if (adapter instanceof IEditingDomainProvider && (editingDomain = (domainProvider = (IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
                                        UpdateManager.this.domain = (TransactionalEditingDomain)editingDomain;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
        });
    }

    private void applyChangeEntries(TransactionalEditingDomain domain, EMap<EObject, EList<FeatureChange>> objectChanges) {
        BasicEMap entriesToApplyLater = new BasicEMap();
        int objectChangesSize = objectChanges.size();
        for (Map.Entry entry : objectChanges) {
            EObject eObject = (EObject)entry.getKey();
            EcoreUtil.getURI((EObject)eObject);
            Resource resourceToChange = eObject.eResource();
            if (eObject.eIsProxy()) {
                entriesToApplyLater.add((Object)entry);
                continue;
            }
            EList featureChanges = (EList)entry.getValue();
            for (FeatureChange featureChange : featureChanges) {
                EStructuralFeature feature = featureChange.getFeature();
                feature.getName();
                EList listChanges = featureChange.getListChanges();
                if (!listChanges.isEmpty()) {
                    for (ListChange listChange : listChanges) {
                        ChangeKind kind = listChange.getKind();
                        int position = listChange.getIndex();
                        EList newObject = listChange.getValues();
                        EList oldList = (EList)eObject.eGet(feature);
                        if (kind == ChangeKind.ADD_LITERAL) {
                            BasicEList newObjectCopy = new BasicEList((Collection)newObject);
                            for (Object object : newObject) {
                                EObject objectinResourceToChange;
                                String id;
                                Resource resource;
                                int index = newObject.indexOf(object);
                                if (!(object instanceof EObject) || (resource = ((EObject)object).eResource()) == null || (id = ((XMIResource)resource).getID((EObject)object)) == null || (objectinResourceToChange = resourceToChange.getEObject(id)) == null) continue;
                                newObjectCopy.set(index, (Object)objectinResourceToChange);
                            }
                            newObject = newObjectCopy;
                            for (Object object : newObject) {
                                if (!(object instanceof EObject)) continue;
                                EcoreUtil.resolveAll((EObject)((EObject)object));
                            }
                            Map<EObject, String> eObjectToIDMap = this.createEObjectToIDMap((EList<Object>)newObject);
                            this.executeADDListChangeCommand(domain, (EList<Object>)oldList, position, (EList<Object>)newObject);
                            if (eObjectToIDMap.isEmpty()) continue;
                            this.setID(eObjectToIDMap);
                            continue;
                        }
                        if (kind == ChangeKind.REMOVE_LITERAL) {
                            this.executeREMOVEListChangeCommand(domain, (EList<Object>)oldList, position);
                            continue;
                        }
                        if (kind != ChangeKind.MOVE_LITERAL) continue;
                        int moveToIndex = listChange.getMoveToIndex();
                        this.executeMOVEListChangeCommand(domain, (EList<Object>)oldList, position, moveToIndex);
                    }
                    continue;
                }
                Object newValue = featureChange.getValue();
                HashMap<EObject, String> eObjectToIDMap = null;
                if (newValue instanceof EObject) {
                    EcoreUtil.resolveAll((EObject)((EObject)newValue));
                    eObjectToIDMap = new HashMap<EObject, String>();
                    this.createEObjectToIDMap((EObject)newValue, eObjectToIDMap);
                }
                this.executeSETCommand(domain, eObject, feature, newValue);
                if (eObjectToIDMap == null || eObjectToIDMap.isEmpty()) continue;
                this.setID(eObjectToIDMap);
            }
        }
        if (!entriesToApplyLater.isEmpty()) {
            if (entriesToApplyLater.size() == objectChangesSize) {
                return;
            }
            this.applyChangeEntries(domain, (EMap<EObject, EList<FeatureChange>>)entriesToApplyLater);
        }
    }

    private void refreshEditpart(EObject edge) {
        if (this.viewer != null) {
            View notationView;
            EditPart editPart = this.viewer.getContents();
            editPart.activate();
            editPart.getViewer().flush();
            editPart.getViewer().getRootEditPart().refresh();
            editPart.getViewer().getRootEditPart().getViewer().flush();
            editPart.getViewer().getRootEditPart().getViewer().getContents().refresh();
            editPart.getViewer().getRootEditPart().getViewer().reveal((EditPart)editPart.getViewer().getRootEditPart());
            editPart.getViewer().flush();
            editPart.refresh();
            Map registry = this.viewer.getEditPartRegistry();
            if (editPart instanceof IGraphicalEditPart && (notationView = ((IGraphicalEditPart)editPart).getNotationView()) instanceof Diagram) {
                Object sourceEditPart = registry.get(((Edge)edge).getSource());
                Object targetEditPart = registry.get(((Edge)edge).getTarget());
                Object edgeEditPart = registry.get(edge);
                System.out.println();
                if (edgeEditPart != null) {
                    EditPart source = ((ConnectionEditPart)edgeEditPart).getSource();
                    EditPart target = ((ConnectionEditPart)edgeEditPart).getTarget();
                    System.out.println();
                }
            }
        }
    }

    private void refreshTargetEditpart(EObject edge) {
        if (this.viewer != null) {
            Object targetEditPart;
            View notationView;
            EditPart editPart = this.viewer.getContents();
            Map registry = this.viewer.getEditPartRegistry();
            if (editPart instanceof IGraphicalEditPart && (notationView = ((IGraphicalEditPart)editPart).getNotationView()) instanceof Diagram && (targetEditPart = registry.get(((Edge)edge).getTarget())) != null) {
                ((EditPart)targetEditPart).refresh();
            }
        }
    }

    private void applyResourceChanges(TransactionalEditingDomain domain, EList<ResourceChange> resourceChanges) {
        for (ResourceChange resourceChange : resourceChanges) {
            Resource resourceToChange = resourceChange.getResource();
            if (resourceToChange == null) {
                return;
            }
            EList listChanges = resourceChange.getListChanges();
            for (ListChange listChange : listChanges) {
                ChangeKind kind = listChange.getKind();
                int index = listChange.getIndex();
                EList newObject = listChange.getValues();
                EList oldList = resourceToChange.getContents();
                if (kind == ChangeKind.ADD_LITERAL) {
                    for (Object object : newObject) {
                        if (!(object instanceof EObject)) continue;
                        EcoreUtil.resolveAll((EObject)((EObject)object));
                        ((EObject)object).eIsProxy();
                    }
                    Map<EObject, String> eObjectToIDMap = this.createEObjectToIDMap((EList<Object>)newObject);
                    this.executeADDListChangeCommand(domain, (EList<Object>)oldList, index, (EList<Object>)newObject);
                    if (eObjectToIDMap.isEmpty()) continue;
                    this.setID(eObjectToIDMap);
                    continue;
                }
                if (kind != ChangeKind.REMOVE_LITERAL) continue;
                this.executeREMOVEListChangeCommand(domain, (EList<Object>)oldList, index);
            }
        }
    }

    private void modifyModel(final ChangeDescription changeDescription) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Resource tempResource;
                ResourceSet resourceSet = UpdateManager.this.domain.getResourceSet();
                EMap objectChanges = changeDescription.getObjectChanges();
                EList resourceChanges = changeDescription.getResourceChanges();
                UpdateManager.this.resolveProxies(resourceSet, (EMap<EObject, EList<FeatureChange>>)objectChanges);
                if (!resourceChanges.isEmpty()) {
                    UpdateManager.this.applyResourceChanges(UpdateManager.this.domain, (EList<ResourceChange>)resourceChanges);
                }
                if (!objectChanges.isEmpty()) {
                    UpdateManager.this.applyChangeEntries(UpdateManager.this.domain, (EMap<EObject, EList<FeatureChange>>)objectChanges);
                }
                if ((tempResource = resourceSet.getResource(URI.createURI((String)"tempResource"), false)) != null) {
                    resourceSet.getResources().remove((Object)tempResource);
                    TransactionUtil.disconnectFromEditingDomain((Resource)tempResource);
                }
                if (UpdateManager.this.viewer != null) {
                    View notationView;
                    EditPart editPart = UpdateManager.this.viewer.getContents();
                    Map registry = UpdateManager.this.viewer.getEditPartRegistry();
                    if (editPart instanceof IGraphicalEditPart && (notationView = ((IGraphicalEditPart)editPart).getNotationView()) instanceof Diagram) {
                        try {
                            EditPart editPart2;
                            CanonicalEditPolicy canonicalEditPolicy2;
                            IEditorPart activeEditor;
                            IWorkbenchPage page;
                            IWorkbench wb;
                            IWorkbenchWindow win;
                            EditPart contents = UpdateManager.this.viewer.getContents();
                            Object model = contents.getModel();
                            if (model instanceof EObject) {
                                EObject eObject = (EObject)model;
                                Resource eResource = eObject.eResource();
                                eResource.setModified(true);
                            }
                            if ((win = (wb = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null && (page = win.getActivePage()) != null && (activeEditor = page.getActiveEditor()) != null) {
                                activeEditor.setFocus();
                            }
                            if ((canonicalEditPolicy2 = (CanonicalEditPolicy)(editPart2 = (EditPart)UpdateManager.this.viewer.getRootEditPart().getChildren().get(0)).getEditPolicy((Object)"Canonical")) != null) {
                                canonicalEditPolicy2.refresh();
                                UpdateManager.this.viewer.getContents().refresh();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        EList edges = ((Diagram)notationView).getEdges();
                        for (Edge edge : edges) {
                            Object sourceEditPart = registry.get(edge.getSource());
                            Object targetEditPart = registry.get(edge.getTarget());
                            if (sourceEditPart == null || targetEditPart == null) continue;
                            ((EditPart)sourceEditPart).refresh();
                            ((EditPart)targetEditPart).refresh();
                            System.out.println();
                        }
                    }
                }
                UpdateManager.updateManager = null;
            }
        });
    }

    private void resolveProxies(ResourceSet resourceSet, EMap<EObject, EList<FeatureChange>> objectChanges) {
        for (Map.Entry entry : objectChanges) {
            EObject key = (EObject)entry.getKey();
            if (!key.eIsProxy()) continue;
            EcoreUtil.resolve((EObject)key, (ResourceSet)resourceSet);
        }
    }

    private void setID(Map<EObject, String> eObjectToIDMap) {
        for (Map.Entry<EObject, String> entry : eObjectToIDMap.entrySet()) {
            String idToSet;
            EObject eObject = entry.getKey();
            Resource eObjectResource = eObject.eResource();
            if (!(eObjectResource instanceof XMIResource) || (idToSet = entry.getValue()) == null) continue;
            ((XMIResource)eObjectResource).setID(eObject, idToSet);
        }
    }

    private Map<EObject, String> createEObjectToIDMap(EList<Object> objectsFromChangeDescription) {
        HashMap<EObject, String> eObjectToIDMap = new HashMap<EObject, String>();
        for (Object object : objectsFromChangeDescription) {
            if (!(object instanceof EObject)) continue;
            this.createEObjectToIDMap((EObject)object, eObjectToIDMap);
        }
        return eObjectToIDMap;
    }

    private void createEObjectToIDMap(EObject objectFromChangeDescription, Map<EObject, String> eObjectToIDMap) {
        XMIResource resource = (XMIResource)objectFromChangeDescription.eResource();
        if (resource != null) {
            String id = resource.getID(objectFromChangeDescription);
            if (id != null) {
                eObjectToIDMap.put(objectFromChangeDescription, id);
            }
            TreeIterator it = EcoreUtil.getAllContents((EObject)objectFromChangeDescription, (boolean)true);
            while (it.hasNext()) {
                EObject contentObject = (EObject)it.next();
                contentObject.eIsProxy();
                id = resource.getID(contentObject);
                if (id == null) continue;
                eObjectToIDMap.put(contentObject, id);
            }
        }
    }
}

