/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.dependencies.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.dosgi.repository.descriptor.IncomingReferencesInfo;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.team.eclipse.dependencies.Activator;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryHelper;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.repository.UserSessionHelper;
import org.modelbus.team.eclipse.ui.repository.model.RepositoryFile;

public class DependenciesView
extends ViewPart {
    public static final int COLUMN_REFERENCING_OBJECTS = 0;
    public static final int COLUMN_OBJECT_TYPE_URI = 2;
    public static final int COLUMN_NAME = 1;
    private Object selectedElement;
    private TableViewer viewer;
    private Action refreshAction;
    private Action doubleClickAction;

    private Object[] getDependencies(Object inputObject) throws IOException, RepositoryAuthentificationException, NonExistingResourceException {
        ArrayList<String[]> output = new ArrayList<String[]>();
        URI inputUri = null;
        if (inputObject instanceof RepositoryFile) {
            inputUri = URI.createURI((String)((RepositoryFile)inputObject).getRepositoryResource().getUrl());
        } else if (inputObject instanceof IFile) {
            inputUri = this.getRemoteLocation(inputObject);
        } else if (inputObject instanceof EObject) {
            inputUri = this.getRemoteLocation(inputObject);
        }
        URI remoteLocation = inputUri;
        if (remoteLocation != null) {
            IRepositoryHelper repositoryHelper = ModelBusRepositoryHelper.getRepositoryHelper();
            IncomingReferencesInfo[] incomingReferencesInfos = repositoryHelper.getIncomingReferences(UserSessionHelper.getSession(), remoteLocation);
            if (incomingReferencesInfos.length == 0) {
                output.add(new String[]{"no incoming references", "", ""});
                return output.toArray();
            }
            int i = 0;
            while (i < incomingReferencesInfos.length) {
                String[] row = new String[]{incomingReferencesInfos[i].getReferencingObjectUri(), incomingReferencesInfos[i].getObjectName(), incomingReferencesInfos[i].getObjectTypeUri()};
                output.add(row);
                ++i;
            }
        } else {
            output.add(new String[]{"not connected", "", ""});
        }
        return output.toArray();
    }

    private URI getRemoteLocation(Object localObject) {
        URI uri = null;
        if (localObject instanceof IFile) {
            IFile file = (IFile)localObject;
            file.getProject();
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)file.getProject(), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
            if (provider != null) {
                ModelBusRepositoryProvider modelBusRepositoryProvider = (ModelBusRepositoryProvider)provider;
                String remoteFileLocation = modelBusRepositoryProvider.getRepositoryPath((IResource)file);
                uri = URI.createURI((String)remoteFileLocation);
            }
        } else if (localObject instanceof EObject) {
            String fragment;
            EObject eObject = (EObject)localObject;
            Resource res = eObject.eResource();
            URI eObjectUri = eObject.eResource().getURI();
            URI eObjectUriWithFragment = eObjectUri.appendFragment(fragment = res.getURIFragment(eObject));
            if (!eObjectUriWithFragment.scheme().equals("http")) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(eObjectUriWithFragment.segment(1));
                IFile resource = project.getFile(eObjectUriWithFragment.toString().substring(eObjectUriWithFragment.toString().indexOf(eObjectUriWithFragment.segment(2))));
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
                if (provider != null) {
                    ModelBusRepositoryProvider modelBusRepositoryProvider = (ModelBusRepositoryProvider)provider;
                    String remoteFileLocation = modelBusRepositoryProvider.getRepositoryPath((IResource)resource);
                    uri = URI.createURI((String)remoteFileLocation);
                }
            } else {
                uri = eObjectUriWithFragment;
            }
        }
        return uri;
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 770);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 4;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384, 0);
        column.setText("Referencing Objects");
        column.setWidth(400);
        column = new TableColumn(table, 16384, 1);
        column.setText("Name");
        column.setWidth(200);
        column = new TableColumn(table, 16384, 2);
        column.setText("Type");
        column.setWidth(400);
        this.viewer = new TableViewer(table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.createActions();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.refreshAction);
        bars.getToolBarManager().update(true);
    }

    private void createActions() {
        this.refreshAction = new Action("Refresh", 1){

            public void run() {
                DependenciesView.this.viewer.refresh();
            }
        };
        this.refreshAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.modelbus.team.eclipse.dependencies", (String)"icons/refresh.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                TableItem[] items;
                TableItem[] tableItemArray = items = DependenciesView.this.viewer.getTable().getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    String text = tableItem.getText();
                    if (!text.isEmpty()) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        File file = new File(text);
                        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                        registry.getEditors(file.getName());
                        DependenciesView.this.showMessage("Double-click detected on ");
                    }
                    ++n2;
                }
            }
        };
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Dependencies View", (String)message);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection structured;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    DependenciesView.this.doubleClickAction.run();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Object[] objects = null;
            try {
                objects = DependenciesView.this.getDependencies(parent);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RepositoryAuthentificationException e) {
                e.printStackTrace();
            }
            catch (NonExistingResourceException e) {
                e.printStackTrace();
            }
            return objects;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(((String[])obj)[index]);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

