/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.notification.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.modelbus.team.eclipse.notification.Activator;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;

public class FilterHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean filter(String url) {
        String regex = Activator.getDefault().getPreferenceStore().getString("MODELBUS_regexp_notification");
        if (!url.matches(regex)) {
            return false;
        }
        if (!FilterHelper.isFilterByProject()) {
            return true;
        }
        try {
            IWorkspace root = ResourcesPlugin.getWorkspace();
            IProject[] projects = root.getRoot().getProjects();
            int i = 0;
            while (true) {
                String projectUrl;
                if (i >= projects.length) {
                    return false;
                }
                if (projects[i].exists() && projects[i].isOpen() && (projectUrl = projects[i].getPersistentProperty(ModelBusRepositoryProvider.MODELBUS_REPO_LOC)) != null && projectUrl != "" && url.startsWith(projectUrl)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isFilterByProject() {
        return Activator.getDefault().getPreferenceStore().getBoolean("MODELBUS_filter_by_open_projects");
    }
}

