/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.notification.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.modelbus.core.lib.notification.INotificationListener;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.team.eclipse.notification.Activator;
import org.modelbus.team.eclipse.notification.views.FilterHelper;
import org.modelbus.team.eclipse.notification.views.TableSortSelectionListener;
import org.modelbus.team.eclipse.notification.views.TextSorter;

public class NotificationView
extends ViewPart
implements INotificationListener {
    public static final String VIEW_ID = "org.modelbus.team.eclipse.notification.views.NotificationView";
    private TableViewer viewer;
    private Action togglePopupAction;
    private Action synchronizeModelAction;
    private Action doubleClickAction;
    private static NotificationView currentNotificationView = null;
    public static ArrayList<String[]> messages = new ArrayList();
    public static boolean checked = Activator.getDefault().getPreferenceStore().getBoolean("MODELBUS_popup_notification");

    public static void addMessage(String url, String type) {
        if (FilterHelper.filter(url)) {
            messages.add(new String[]{"", url, type, new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS").format(new Date())});
            if (currentNotificationView != null) {
                UIJob uiJob = new UIJob("Model " + url + " has been updated."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        currentNotificationView.viewer.refresh();
                        if (checked && currentNotificationView != null) {
                            MessageDialog.openInformation((Shell)currentNotificationView.getViewSite().getShell(), (String)"Notification View", (String)this.getName());
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
            }
        }
    }

    public NotificationView() {
        currentNotificationView = this;
        NotificationListenerManager nManager = Activator.getDefault().getNotificationListenerManager();
        if (nManager != null) {
            nManager.addNotificationListener((INotificationListener)this);
        }
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 770);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setText("!");
        column.setWidth(20);
        column = new TableColumn(table, 16384, 1);
        column.setText("Model");
        column.setWidth(400);
        column = new TableColumn(table, 16384, 2);
        column.setText("Type");
        column.setWidth(100);
        column = new TableColumn(table, 0x1000000, 3);
        column.setText("Time");
        column.setWidth(120);
        this.viewer = new TableViewer(table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.modelbus.team.eclipse.notification.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        new TableSortSelectionListener(this.viewer, column, new TextSorter(3), 1024, true).chooseColumnForSorting();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NotificationView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.getToolBarManager().update(true);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.togglePopupAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.synchronizeModelAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.synchronizeModelAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.togglePopupAction);
    }

    private void makeActions() {
        this.togglePopupAction = new Action("Enable PopUp", 2){

            public void run() {
                checked = !checked;
                this.setChecked(checked);
            }
        };
        this.togglePopupAction.setChecked(true);
        this.togglePopupAction.setText("Enable PopUp");
        this.togglePopupAction.setToolTipText("Action 1 tooltip");
        this.togglePopupAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.synchronizeModelAction = new Action(){

            public void run() {
                NotificationView.this.showMessage("Synchronize Model");
            }
        };
        this.synchronizeModelAction.setText("Synchronize Model");
        this.synchronizeModelAction.setToolTipText("Synchronizes the local model information with the repository");
        this.synchronizeModelAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = NotificationView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                NotificationView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NotificationView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Notification View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notification(String url, String mode, String user, String sessionID) {
        NotificationView.addMessage(url, mode);
    }

    public void commitChangeModelNotification(String modelUri, String messageID, String changeModelContent) {
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return messages.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(((String[])obj)[index]);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

