/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.notification.views;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.modelbus.team.eclipse.notification.views.AbstractInvertableTableSorter;
import org.modelbus.team.eclipse.notification.views.InvertableSorter;

public class TableSortSelectionListener
implements SelectionListener {
    private final TableViewer viewer;
    private final TableColumn column;
    private final InvertableSorter sorter;
    private final boolean keepDirection;
    private InvertableSorter currentSorter;

    public TableSortSelectionListener(TableViewer viewer, TableColumn column, AbstractInvertableTableSorter sorter, int defaultDirection, boolean keepDirection) {
        this.viewer = viewer;
        this.column = column;
        this.keepDirection = keepDirection;
        this.currentSorter = this.sorter = defaultDirection == 128 ? sorter : sorter.getInverseSorter();
        this.column.addSelectionListener((SelectionListener)this);
    }

    public void chooseColumnForSorting() {
        this.viewer.getTable().setSortColumn(this.column);
        this.viewer.getTable().setSortDirection(this.currentSorter.getSortDirection());
        this.viewer.setSorter((ViewerSorter)this.currentSorter);
    }

    public void widgetSelected(SelectionEvent e) {
        InvertableSorter newSorter = this.viewer.getTable().getSortColumn() == this.column ? ((InvertableSorter)this.viewer.getSorter()).getInverseSorter() : (this.keepDirection ? this.currentSorter : this.sorter);
        this.currentSorter = newSorter;
        this.chooseColumnForSorting();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

