/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard.newservice;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ManifestManipulator {
    private Manifest manifest;

    public ManifestManipulator(Manifest manifest) {
        this.manifest = manifest;
    }

    public void addExportPackage(String packageName) throws BundleException {
        boolean foundHeader = false;
        StringBuilder strBuilder = new StringBuilder();
        Attributes mainAttrs = this.manifest.getMainAttributes();
        for (Object entryName : mainAttrs.keySet()) {
            String values;
            String header;
            if (entryName instanceof String) {
                header = (String)entryName;
                values = mainAttrs.getValue(header);
            } else if (entryName instanceof Attributes.Name) {
                header = ((Attributes.Name)entryName).toString();
                values = mainAttrs.getValue((Attributes.Name)entryName);
            } else {
                throw new BundleException("Unknown key type: " + entryName.getClass() + " (" + entryName + ")");
            }
            if (!"Export-Package".equals(header)) continue;
            foundHeader = true;
            if (values == null) continue;
            ManifestElement[] elements = ManifestElement.parseHeader((String)header, (String)values);
            boolean packageAlreadyExported = false;
            int i = 0;
            while (i < elements.length) {
                ManifestElement manifestElement = elements[i];
                StringBuilder valueComponents = new StringBuilder();
                boolean lastElement = i >= elements.length - 1;
                boolean firstElement = i == 0;
                int j = 0;
                while (j < manifestElement.getValueComponents().length) {
                    String pureValue = manifestElement.getValueComponents()[j];
                    if (packageName.equalsIgnoreCase(pureValue)) {
                        packageAlreadyExported = true;
                        valueComponents.append(pureValue);
                    }
                    if (!packageAlreadyExported) {
                        strBuilder.append(String.valueOf(firstElement ? "" : " ") + manifestElement.getValue() + (lastElement ? "" : ",\n"));
                    } else {
                        strBuilder.append(String.valueOf(firstElement ? "" : " ") + valueComponents);
                        if (!lastElement) {
                            strBuilder.append(",\n");
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (!packageAlreadyExported) {
                strBuilder.append(String.valueOf(elements.length == 0 ? "" : ",\n ") + packageName);
            }
            this.manifest.getMainAttributes().putValue("Export-Package", strBuilder.toString());
        }
        if (!foundHeader) {
            this.manifest.getMainAttributes().putValue("Export-Package", packageName);
        }
    }

    public void writeManifest(FileOutputStream stream) throws IOException {
        this.manifest.write(stream);
    }
}

