/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard.newservice;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.modelbus.core.lib.configuration.ModelBusServiceException;

public class NewServiceUtilJavaReflect {
    public static boolean checkServiceAnnotations(Class<?> svcInterface) throws ModelBusServiceException {
        NewServiceUtilJavaReflect.checkInterfaceAnnotations(svcInterface);
        Method[] methodArray = svcInterface.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            NewServiceUtilJavaReflect.checkMethodAnnotations(method);
            ++n2;
        }
        return true;
    }

    private static void checkInterfaceAnnotations(Class<?> svcInterface) throws ModelBusServiceException {
        WebService wsAnnotation = (WebService)NewServiceUtilJavaReflect.getServiceAnnotation(svcInterface, WebService.class);
        String targetNamespace = wsAnnotation.targetNamespace();
        String name = wsAnnotation.name();
        if (targetNamespace == null || targetNamespace.isEmpty()) {
            throw new ModelBusServiceException("No target namespace defined for service interface " + svcInterface.getName());
        }
        if (name == null || name.isEmpty()) {
            throw new ModelBusServiceException("No service name defined for service interface " + svcInterface.getName());
        }
        if (!targetNamespace.endsWith("/")) {
            throw new ModelBusServiceException("The service namespace should end with a slash.");
        }
    }

    private static Annotation getServiceAnnotation(Class<?> annotationOwner, Class annotationClass) throws ModelBusServiceException {
        Annotation[] annotationArray = annotationOwner.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationClass.isAssignableFrom(annotation.getClass())) {
                return annotation;
            }
            ++n2;
        }
        throw new ModelBusServiceException("Annotation " + annotationClass.getName() + " not found for service interface: " + annotationOwner.getName());
    }

    private static Annotation getMethodAnnotation(Method method, Class annotationClass) throws ModelBusServiceException {
        Annotation[] annotationArray = method.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationClass.isAssignableFrom(annotation.getClass())) {
                return annotation;
            }
            ++n2;
        }
        throw new ModelBusServiceException("Annotation " + annotationClass.getName() + " not found for method: \"" + method.getName() + "\"");
    }

    private static void checkMethodAnnotations(Method method) throws ModelBusServiceException {
        boolean isVoidMethod;
        WebMethod webMethodAnnotation = (WebMethod)NewServiceUtilJavaReflect.getMethodAnnotation(method, WebMethod.class);
        String methodAction = webMethodAnnotation.action();
        WebResult webResultAnnotation = (WebResult)NewServiceUtilJavaReflect.getMethodAnnotation(method, WebResult.class);
        String methodResult = webResultAnnotation.name();
        boolean bl = isVoidMethod = "void".equals(method.getReturnType());
        if (methodAction == null || !isVoidMethod && methodAction.isEmpty()) {
            throw new ModelBusServiceException("No action defined for method \"" + method.getName() + "\"");
        }
        WebService webServiceAnnotation = (WebService)NewServiceUtilJavaReflect.getServiceAnnotation(method.getDeclaringClass(), WebService.class);
        if (!methodAction.startsWith(webServiceAnnotation.targetNamespace())) {
            throw new ModelBusServiceException("The action of the method \"" + method.getName() + "\" should be in the namespace of " + method.getDeclaringClass().getName());
        }
        if (isVoidMethod && methodResult != null && !methodResult.isEmpty()) {
            System.out.println("WARNING: annotation @WebResult for void method \"" + method.getName() + "\" found.");
        }
        Annotation[][] paramAnnotationsArray = method.getParameterAnnotations();
        int i = 1;
        Annotation[][] annotationArray = paramAnnotationsArray;
        int n = paramAnnotationsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] paramAnnotations = annotationArray[n2];
            if (paramAnnotations.length == 0) {
                throw new ModelBusServiceException("Parameter " + i + " of method \"" + method.getName() + "\" is not annotated.");
            }
            Annotation[] annotationArray2 = paramAnnotations;
            int n3 = paramAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation paramAnnotation = annotationArray2[n4];
                boolean webParamAnnotationFound = false;
                if (paramAnnotation instanceof WebParam) {
                    webParamAnnotationFound = true;
                    WebParam webParamAnnotation = (WebParam)paramAnnotation;
                    String webParamName = webParamAnnotation.name();
                    if (webParamName == null || webParamName.isEmpty()) {
                        throw new ModelBusServiceException("Invalid value for attribute \"name\" of annotation " + WebParam.class.getName() + " for parameter " + i + " of method \"" + method.getName() + "\".");
                    }
                }
                if (!webParamAnnotationFound) {
                    throw new ModelBusServiceException("Missing annotation " + WebParam.class.getName() + " for parameter " + i + " of method \"" + method.getName() + "\".");
                }
                ++n4;
            }
            ++i;
            ++n2;
        }
    }
}

