/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard.newservice;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ProjectCreationHelper {
    public static final String NATURE_PDE = "org.eclipse.pde.PluginNature";

    public static IJavaProject createProject(final String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> importedPackages, List<String> exportedPackages, IProgressMonitor progressMonitor, Set<String> additionalBuildPath, final Shell theShell) {
        IProject project = null;
        IJavaProject javaProject = null;
        try {
            progressMonitor.beginTask("", 10);
            progressMonitor.subTask("Creating project " + projectName);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(projectName);
            if (project.exists()) {
                final boolean[] result = new boolean[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = MessageDialog.openQuestion((Shell)theShell, (String)("Do you want to overwrite the project " + projectName), (String)("Note that everything inside the project '" + projectName + "' will be deleted if you confirm this dialog."));
                    }
                });
                if (result[0]) {
                    project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    return null;
                }
            }
            try {
                javaProject = JavaCore.create((IProject)project);
                IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                projectDescription.setLocation(null);
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
                if (!referencedProjects.isEmpty()) {
                    projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                    for (IProject referencedProject : referencedProjects) {
                        IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                        classpathEntries.add(referencedProjectClasspathEntry);
                    }
                }
                projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", NATURE_PDE});
                ICommand java = projectDescription.newCommand();
                java.setBuilderName("org.eclipse.jdt.core.javabuilder");
                ICommand manifest = projectDescription.newCommand();
                manifest.setBuilderName("org.eclipse.pde.ManifestBuilder");
                ICommand schema = projectDescription.newCommand();
                schema.setBuilderName("org.eclipse.pde.SchemaBuilder");
                projectDescription.setBuildSpec(new ICommand[]{java, manifest, schema});
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                Collections.reverse(srcFolders);
                for (String src : srcFolders) {
                    IFolder srcContainer = project.getFolder(src);
                    if (!srcContainer.exists()) {
                        srcContainer.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
                    classpathEntries.add(0, srcClasspathEntry);
                }
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6")));
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                javaProject.setOutputLocation((IPath)new Path("/" + projectName + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                ProjectCreationHelper.createManifest(projectName, requiredBundles, importedPackages, exportedPackages, progressMonitor, project);
                for (String buildPathFolder : additionalBuildPath) {
                    IFolder buildFolder = project.getFolder(buildPathFolder);
                    if (buildFolder.exists()) continue;
                    buildFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                ProjectCreationHelper.createBuildProps(progressMonitor, project, srcFolders, additionalBuildPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            progressMonitor.done();
        }
        return javaProject;
    }

    public static IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        IFile file = container.getFile((IPath)new Path(name));
        ProjectCreationHelper.assertExist(file.getParent());
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, progressMonitor);
            } else {
                file.create((InputStream)stream, true, progressMonitor);
            }
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        progressMonitor.worked(1);
        return file;
    }

    private static void createBuildProps(IProgressMonitor progressMonitor, IProject project, List<String> srcFolders, Set<String> additionBuildPath) {
        StringBuilder bpContent = new StringBuilder("source.. = ");
        Iterator<String> iterator = srcFolders.iterator();
        while (iterator.hasNext()) {
            bpContent.append(iterator.next()).append('/');
            if (!iterator.hasNext()) continue;
            bpContent.append(",");
        }
        bpContent.append("\n");
        bpContent.append("bin.includes = META-INF/,\\\n.");
        for (String buildFolder : additionBuildPath) {
            bpContent.append(", " + buildFolder + "/\\\n");
        }
        bpContent.append("\n");
        ProjectCreationHelper.createFile("build.properties", (IContainer)project, bpContent.toString(), progressMonitor);
    }

    private static void createManifest(String projectName, Set<String> requiredBundles, List<String> importedPackages, List<String> exportedPackages, IProgressMonitor progressMonitor, IProject project) throws CoreException {
        int i;
        StringBuilder manifest = new StringBuilder("Manifest-Version: 1.0\n");
        manifest.append("Bundle-ManifestVersion: 2\n");
        manifest.append("Bundle-Name: " + projectName + "\n");
        manifest.append("Bundle-SymbolicName: " + projectName + ";singleton:=true\n");
        manifest.append("Bundle-Version: 1.0.0\n");
        manifest.append("Bundle-Localization: plugin\n");
        if (requiredBundles != null && !requiredBundles.isEmpty()) {
            manifest.append("Require-Bundle: ");
            i = 0;
            for (String entry : requiredBundles) {
                if (i < requiredBundles.size() - 1) {
                    manifest.append(" " + entry + ",\n");
                } else {
                    manifest.append(" " + entry + "\n");
                }
                ++i;
            }
        }
        if (importedPackages != null && !importedPackages.isEmpty()) {
            manifest.append("Import-Package: " + importedPackages.get(0));
            i = 1;
            int x = importedPackages.size();
            while (i < x) {
                manifest.append(",\n " + importedPackages.get(i));
                ++i;
            }
            manifest.append("\n");
        }
        if (exportedPackages != null && !exportedPackages.isEmpty()) {
            manifest.append("Export-Package: " + exportedPackages.get(0));
            i = 1;
            int x = exportedPackages.size();
            while (i < x) {
                manifest.append(",\n " + exportedPackages.get(i));
                ++i;
            }
            manifest.append("\n");
        }
        manifest.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.6\r\n");
        IFolder metaInf = project.getFolder("META-INF");
        metaInf.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        ProjectCreationHelper.createFile("MANIFEST.MF", (IContainer)metaInf, manifest.toString(), progressMonitor);
    }

    public static IFile createFile(String name, IContainer container, URL contentUrl, IProgressMonitor progressMonitor) {
        IFile file;
        block16: {
            file = container.getFile((IPath)new Path(name));
            InputStream inputStream = null;
            try {
                try {
                    inputStream = contentUrl.openStream();
                    if (file.exists()) {
                        file.setContents(inputStream, true, true, progressMonitor);
                    } else {
                        file.create(inputStream, true, progressMonitor);
                    }
                    inputStream.close();
                }
                catch (Exception exception) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        progressMonitor.worked(1);
        return file;
    }

    private static void assertExist(IContainer c) {
        if (!c.exists()) {
            if (!c.getParent().exists()) {
                ProjectCreationHelper.assertExist(c.getParent());
            }
            if (c instanceof IFolder) {
                try {
                    ((IFolder)c).create(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
        }
    }

    public static void openFileToEdit(Shell s, final IFile file) {
        s.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

