/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.wizard.newservice;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.team.eclipse.ui.wizard.AbstractVerifiedWizardPage;
import org.modelbus.team.eclipse.ui.wizard.newservice.NewServiceUtilJavaReflect;

public class SelectServicePartWizardPage
extends AbstractVerifiedWizardPage {
    public static final String TYPE_PROVIDER = "Provider";
    public static final String TYPE_CONSUMER = "Consumer";
    private IType serviceInterface;
    private String serviceType;
    private IJavaProject currentProject;
    private Composite parent;
    private Combo typeCombo;
    private Text projectNameInput;
    private Text interfaceInput;

    public SelectServicePartWizardPage(String pageName, IJavaProject currentProject) {
        super(pageName);
        this.currentProject = currentProject;
        this.setTitle("New ModelBus Service from Interface");
        this.setMessage("Please specify the project name and select the service interface");
    }

    protected Composite createControlImpl(Composite parent) {
        this.parent = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        GridData inputGriddata = new GridData();
        inputGriddata.widthHint = 200;
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText("Type:");
        this.typeCombo = new Combo(composite, 8);
        this.typeCombo.add(TYPE_PROVIDER);
        this.typeCombo.add(TYPE_CONSUMER);
        this.typeCombo.setLayoutData((Object)inputGriddata);
        this.typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServicePartWizardPage.this.serviceType = SelectServicePartWizardPage.this.typeCombo.getText();
            }
        });
        this.typeCombo.setText(TYPE_PROVIDER);
        Label projectNameLabel = new Label(composite, 0);
        projectNameLabel.setText("Project name:");
        this.projectNameInput = new Text(composite, 2048);
        this.projectNameInput.setLayoutData((Object)inputGriddata);
        this.projectNameInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SelectServicePartWizardPage.this.setPageComplete(SelectServicePartWizardPage.this.isPageComplete());
            }
        });
        Label interfaceLabel = new Label(composite, 0);
        interfaceLabel.setText("Service Interface:");
        Composite interfaceComposite = new Composite(composite, 0);
        GridLayout interfaceCompositeLayout = new GridLayout();
        interfaceCompositeLayout.numColumns = 2;
        interfaceCompositeLayout.verticalSpacing = 0;
        interfaceCompositeLayout.horizontalSpacing = 0;
        interfaceComposite.setLayout((Layout)layout);
        this.interfaceInput = new Text(interfaceComposite, 2048);
        GridData interfaceInputGriddata = new GridData();
        interfaceInputGriddata.widthHint = 200;
        this.interfaceInput.setLayoutData((Object)interfaceInputGriddata);
        this.interfaceInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SelectServicePartWizardPage.this.setPageComplete(SelectServicePartWizardPage.this.isPageComplete());
            }
        });
        Button chooseButton = new Button(interfaceComposite, 8);
        chooseButton.setText("Choose...");
        chooseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                try {
                    IType type;
                    Object selectedItem;
                    Object[] results;
                    if (SelectServicePartWizardPage.this.currentProject == null) {
                        MessageDialog.openInformation((Shell)SelectServicePartWizardPage.this.parent.getShell(), (String)"No project selected", (String)"No project selected");
                        return;
                    }
                    SelectionDialog typeDialog = JavaUI.createTypeDialog((Shell)SelectServicePartWizardPage.this.getShell(), (IRunnableContext)new ProgressMonitorDialog(SelectServicePartWizardPage.this.getShell()), (IProject)SelectServicePartWizardPage.this.currentProject.getProject(), (int)256, (boolean)false);
                    typeDialog.setTitle("Select Service Interface");
                    typeDialog.setMessage("Select the java service interface");
                    int result = typeDialog.open();
                    if (result == 0 && (results = typeDialog.getResult()).length > 0 && (selectedItem = results[0]) instanceof IType && (type = (IType)selectedItem).isInterface()) {
                        SelectServicePartWizardPage.this.serviceInterface = type;
                        SelectServicePartWizardPage.this.interfaceInput.setText(type.getFullyQualifiedName('.'));
                        SelectServicePartWizardPage.this.setPageComplete(SelectServicePartWizardPage.this.isPageComplete());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
        if (this.currentProject == null) {
            this.setErrorMessage("No project selected.");
        }
        if (!this.projectNatureOK()) {
            this.setErrorMessage("Selected project has to be a plug-in project.");
        }
        return composite;
    }

    private boolean projectNatureOK() {
        if (this.currentProject == null) {
            return false;
        }
        try {
            IProjectNature nature = this.currentProject.getProject().getNature("org.eclipse.pde.PluginNature");
            return nature != null;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPageComplete() {
        boolean interfaceOkay;
        IProject[] projects;
        boolean projectNameOK;
        boolean projectTypeOK;
        this.setMessage("");
        if (!this.projectNatureOK()) {
            this.setErrorMessage("Selected project has to be a plug-in project.");
            return false;
        }
        String projectType = this.typeCombo.getText();
        String projectName = this.projectNameInput.getText();
        boolean bl = projectTypeOK = projectType != null && !projectType.isEmpty();
        if (!projectTypeOK) {
            this.setErrorMessage("Invalid project type.");
            return false;
        }
        boolean bl2 = projectNameOK = projectName != null && !projectName.isEmpty();
        if (!projectNameOK) {
            this.setErrorMessage("Please specify a project name.");
            return false;
        }
        Pattern p = Pattern.compile("[a-zA-Z0-9\\.]+");
        Matcher m = p.matcher(projectName);
        if (!m.matches()) {
            this.setErrorMessage("\"" + projectName + "\" is not a valid project name.");
            return false;
        }
        IWorkspace root = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = projects = root.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(projectName)) {
                this.setErrorMessage("Project \"" + projectName + "\" already exists.");
                return false;
            }
            ++n2;
        }
        String interfaceName = this.interfaceInput.getText();
        boolean bl3 = interfaceOkay = interfaceName != null && !interfaceName.isEmpty();
        if (interfaceOkay) {
            Class<?> svcInterface = null;
            try {
                String[] classPaths = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this.currentProject);
                URL[] urls = new URL[classPaths.length];
                int i = 0;
                while (i < classPaths.length) {
                    urls[i] = new URL("file:///" + SelectServicePartWizardPage.computeForURLClassLoader(classPaths[i]));
                    ++i;
                }
                URLClassLoader loader = new URLClassLoader(urls);
                svcInterface = loader.loadClass(this.serviceInterface.getFullyQualifiedName());
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            try {
                NewServiceUtilJavaReflect.checkServiceAnnotations(svcInterface);
            }
            catch (ModelBusServiceException e1) {
                this.setErrorMessage(e1.getMessage());
                return false;
            }
        }
        return true;
    }

    private static String computeForURLClassLoader(String classpath) {
        File file;
        if (!classpath.endsWith("/") && (file = new File(classpath)).exists() && file.isDirectory()) {
            classpath = classpath.concat("/");
        }
        return classpath;
    }

    public IType getServiceInterface() {
        return this.serviceInterface;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getProjectName() {
        return this.projectNameInput.getText();
    }
}

