/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.events.IResourceStatesListener;
import org.modelbus.team.eclipse.core.resource.events.ResourceStatesChangedEvent;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.repository.RepositoryFileEditorInput;
import org.modelbus.team.eclipse.ui.repository.model.IResourceTreeNode;

public abstract class AbstractModelBusView
extends ViewPart
implements IResourceStatesListener {
    protected IResource wcResource;
    protected IRepositoryResource repositoryResource;
    protected Resource repositoryElementResource;
    protected EObject eObject;
    protected String viewDescription;
    protected Object lastSelectedElement;
    protected boolean isLinkWithEditorEnabled;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                AbstractModelBusView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part == AbstractModelBusView.this) {
                AbstractModelBusView.this.editorActivated(AbstractModelBusView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == AbstractModelBusView.this) {
                AbstractModelBusView.this.editorActivated(AbstractModelBusView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    };
    protected IPartListener2 partListener2 = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getPart(true) == AbstractModelBusView.this) {
                AbstractModelBusView.this.editorActivated(AbstractModelBusView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    };
    protected ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                AbstractModelBusView.this.lastSelectedElement = structSelection.getFirstElement();
                if (!AbstractModelBusView.this.isLinkWithEditorEnabled || !AbstractModelBusView.this.isPageVisible()) {
                    return;
                }
                if (AbstractModelBusView.this.lastSelectedElement != null) {
                    if (AbstractModelBusView.this.lastSelectedElement instanceof IResource) {
                        IResource resource = (IResource)AbstractModelBusView.this.lastSelectedElement;
                        AbstractModelBusView.this.updateViewInput(resource);
                        AbstractModelBusView.this.lastSelectedElement = null;
                    } else if (AbstractModelBusView.this.lastSelectedElement instanceof IAdaptable) {
                        if (AbstractModelBusView.this.lastSelectedElement instanceof IResourceTreeNode) {
                            IResourceTreeNode remote = (IResourceTreeNode)AbstractModelBusView.this.lastSelectedElement;
                            AbstractModelBusView.this.updateViewInput(remote.getRepositoryResource());
                        } else {
                            Object adapted = ((IAdaptable)AbstractModelBusView.this.lastSelectedElement).getAdapter(IResource.class);
                            if (adapted instanceof IResource) {
                                AbstractModelBusView.this.updateViewInput((IResource)adapted);
                            }
                        }
                    }
                }
            }
        }
    };

    public AbstractModelBusView(String viewDescription) {
        this.viewDescription = viewDescription;
        ModelBusRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
    }

    public void createPartControl(Composite parent) {
        if (this.needsLinkWithEditorAndSelection()) {
            this.getSite().getPage().addPartListener(this.partListener);
            this.getSite().getPage().addPartListener(this.partListener2);
            this.getSite().getPage().addSelectionListener(this.selectionListener);
        }
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        if (this.wcResource == null) {
            return;
        }
        if (event.contains(this.wcResource) || event.contains((IResource)this.wcResource.getProject())) {
            if (!this.wcResource.exists() || !FileUtility.isConnected((IResource)this.wcResource)) {
                this.disconnectView();
            } else {
                ILocalResource local = ModelBusRemoteStorage.instance().asLocalResource(this.wcResource);
                if (IStateFilter.SF_UNVERSIONED.accept(local) || IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                    this.disconnectView();
                }
            }
            this.refreshView();
        }
    }

    protected void showResourceLabel() {
        String resourceName;
        if (this.wcResource != null) {
            String path = this.wcResource.getFullPath().toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            resourceName = path;
        } else {
            resourceName = this.eObject != null ? EcoreUtil.getURI((EObject)this.eObject).toString() : (this.repositoryResource != null ? this.repositoryResource.getUrl() : (this.repositoryElementResource != null ? this.repositoryElementResource.getURI().toString() : ModelBusTeamUIPlugin.instance().getResource("ModelBusView.ResourceNotSelected")));
        }
        this.setContentDescription(resourceName);
    }

    protected boolean isPageVisible() {
        return this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void dispose() {
        if (this.needsLinkWithEditorAndSelection()) {
            this.getSite().getPage().removePartListener(this.partListener);
            this.getSite().getPage().removePartListener(this.partListener2);
            this.getSite().getPage().removeSelectionListener(this.selectionListener);
        }
        ModelBusRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
        super.dispose();
    }

    protected void editorActivated(IEditorPart editor) {
        if (editor != null && !this.isPageVisible()) {
            this.lastSelectedElement = editor;
        }
        if (editor == null || !this.isLinkWithEditorEnabled || !this.isPageVisible()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input != null) {
            if (input instanceof IFileEditorInput || input instanceof SyncInfoCompareInput) {
                Object adapter = input.getAdapter(IFile.class);
                if (adapter instanceof IFile) {
                    this.updateViewInput((IResource)((IFile)adapter));
                }
            } else if (input instanceof RepositoryFileEditorInput) {
                this.updateViewInput(((RepositoryFileEditorInput)input).getRepositoryResource());
            }
        }
    }

    protected void updateViewInput(IResource resource) {
    }

    protected void updateViewInput(IRepositoryResource resource) {
    }

    protected abstract boolean needsLinkWithEditorAndSelection();

    protected abstract void disconnectView();

    protected abstract void refreshView();
}

