/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.subscribers.SubscriberChangeSetManager;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.modelbus.team.eclipse.core.ModelBusTeamPlugin;
import org.modelbus.team.eclipse.core.operation.IConsoleStream;
import org.modelbus.team.eclipse.core.operation.LoggedOperation;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ProjectCloseListener;
import org.modelbus.team.eclipse.ui.console.ModelBusConsole;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.status.ModelBusRepositoryPing;
import org.modelbus.team.eclipse.ui.status.ModelBusStatusLineContributionItem;
import org.modelbus.team.eclipse.ui.status.ModelBusStatusProvider;
import org.modelbus.team.eclipse.ui.synchronize.update.UpdateSubscriber;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ModelBusTeamUIPlugin
extends AbstractUIPlugin {
    private static volatile ModelBusTeamUIPlugin instance = null;
    private ProjectCloseListener pcListener = new ProjectCloseListener();
    private URL baseUrl;
    private ModelBusConsole console;
    private SubscriberChangeSetManager changeSetManager;
    private ModelBusRepositoryPing pingThread;
    private ModelBusStatusProvider status = new ModelBusStatusProvider();
    private final long pingInterval = 5000L;

    public ModelBusTeamUIPlugin() {
        instance = this;
    }

    public static ModelBusTeamUIPlugin instance() {
        return instance;
    }

    public IConsoleStream getConsoleStream() {
        return this.console == null ? null : this.console.getConsoleStream();
    }

    public String getResource(String key) {
        return FileUtility.getResource((ResourceBundle)Platform.getResourceBundle((Bundle)this.getBundle()), (String)key);
    }

    public String getResource(String key, Object[] args) {
        String message = this.getResource(key);
        return MessageFormat.format(message, args);
    }

    public ImageDescriptor getImageDescriptor(String path) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(this.baseUrl, path));
        }
        catch (MalformedURLException e) {
            LoggedOperation.reportError((String)this.getResource("Error.GetImageDescriptor"), (Throwable)e);
            return null;
        }
    }

    public String getVersionString() {
        return (String)this.getBundle().getHeaders().get("Bundle-Version");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ModelBusTeamPreferences.setDefaultValues(this.getPreferenceStore());
        Preferences corePreferences = ModelBusTeamPlugin.instance().getPluginPreferences();
        String connector = corePreferences.getString("modelbusconnector").trim();
        if (connector.length() != 0) {
            ModelBusTeamPreferences.setCoreString(this.getPreferenceStore(), "modelbusconnector", connector);
            corePreferences.setValue("modelbusconnector", "");
            ModelBusTeamPlugin.instance().savePluginPreferences();
        }
        this.baseUrl = context.getBundle().getEntry("/");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.pcListener, 6);
        this.console = new ModelBusConsole();
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        PerspectiveAdapter perspectiveListener = new PerspectiveAdapter(){
            private boolean itemAdded = false;

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (window instanceof WorkbenchWindow && !this.itemAdded) {
                    WorkbenchWindow workbenchWindow = (WorkbenchWindow)window;
                    StatusLineManager manager = workbenchWindow.getStatusLineManager();
                    ModelBusStatusLineContributionItem item = new ModelBusStatusLineContributionItem("modelbus.status");
                    ModelBusTeamUIPlugin.this.status.addObserver(item);
                    manager.add((IContributionItem)item);
                    item.update();
                    manager.update(true);
                    this.itemAdded = true;
                }
            }
        };
        if (window != null) {
            window.addPerspectiveListener((IPerspectiveListener)perspectiveListener);
        }
        this.pingThread = new ModelBusRepositoryPing(5000L);
        this.pingThread.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.console.shutdown();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.pcListener);
        if (this.changeSetManager != null) {
            this.changeSetManager.dispose();
        }
        this.pingThread.kill();
        super.stop(context);
    }

    public synchronized SubscriberChangeSetManager getChangeSetManager() {
        if (this.changeSetManager == null) {
            this.changeSetManager = new SubscriberChangeSetManager((Subscriber)UpdateSubscriber.instance());
        }
        return this.changeSetManager;
    }

    public ModelBusStatusProvider getStatus() {
        return this.status;
    }
}

