/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui;

import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.modelbus.team.eclipse.core.connector.IModelBusCredentialsPrompt;
import org.modelbus.team.eclipse.core.connector.ModelBusProperty;
import org.modelbus.team.eclipse.core.extension.options.IOptionProvider;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.utility.ILoggedOperationFactory;
import org.modelbus.team.eclipse.core.utility.StringMatcher;
import org.modelbus.team.eclipse.ui.ModelBusTeamModificationValidator;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.panel.callback.PromptCredentialsPanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPropsPreferencePage;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class UIOptionProvider
implements IOptionProvider {
    private ModelBusTeamModificationValidator modificationValidator = new ModelBusTeamModificationValidator();

    public IModelBusCredentialsPrompt getCredentialsPrompt() {
        return PromptCredentialsPanel.DEFAULT_PROMPT;
    }

    public ILoggedOperationFactory getLoggedOperationFactory() {
        return UIMonitorUtility.DEFAULT_FACTORY;
    }

    public void addProjectSetCapabilityProcessing(CompositeOperation op) {
        System.out.println("CHECKMWA15");
    }

    public boolean isAutomaticProjectShareEnabled() {
        return ModelBusTeamPreferences.getBehaviourBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "share.enableAuto");
    }

    public FileModificationValidator getFileModificationValidator() {
        return this.modificationValidator;
    }

    public String getModelBusConnectorId() {
        return ModelBusTeamPreferences.getCoreString(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "modelbusconnector");
    }

    public String getDefaultBranchesName() {
        String retVal = ModelBusTeamPreferences.getRepositoryString(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "branches");
        if (retVal == null || retVal.length() == 0) {
            retVal = "branches";
        }
        return retVal;
    }

    public String getDefaultTagsName() {
        String retVal = ModelBusTeamPreferences.getRepositoryString(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "tags");
        if (retVal == null || retVal.length() == 0) {
            retVal = "tags";
        }
        return retVal;
    }

    public String getDefaultTrunkName() {
        String retVal = ModelBusTeamPreferences.getRepositoryString(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "head");
        if (retVal == null || retVal.length() == 0) {
            retVal = "trunk";
        }
        return retVal;
    }

    public boolean isModelBusCacheEnabled() {
        return ModelBusTeamPreferences.getDecorationBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "enable.cache");
    }

    public ModelBusProperty[] getAutomaticProperties(String template) {
        IPreferenceStore store = ModelBusTeamUIPlugin.instance().getPreferenceStore();
        Object[] autoProperties = ModelBusTeamPropsPreferencePage.loadAutoProperties(ModelBusTeamPreferences.getAutoPropertiesList(store, "autoproperties"));
        int i = 0;
        while (i < autoProperties.length) {
            StringMatcher matcher;
            ModelBusTeamPropsPreferencePage.AutoProperty autoProperty = (ModelBusTeamPropsPreferencePage.AutoProperty)autoProperties[i];
            if (autoProperty.enabled && (matcher = new StringMatcher(autoProperty.fileName)).match(template)) {
                if (autoProperty.properties.length() == 0) {
                    return new ModelBusProperty[0];
                }
                String[] props = autoProperty.properties.split(";");
                ModelBusProperty[] propertyData = new ModelBusProperty[props.length];
                int j = 0;
                while (j < props.length) {
                    String[] propsNameValue = props[j].split("=");
                    propertyData[j] = new ModelBusProperty(propsNameValue[0], propsNameValue.length == 1 ? "" : propsNameValue[1]);
                    ++j;
                }
                return propertyData;
            }
            ++i;
        }
        return new ModelBusProperty[0];
    }

    public String getResource(String key) {
        return ModelBusTeamUIPlugin.instance().getResource(key);
    }
}

