/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.events.IResourceStatesListener;
import org.modelbus.team.eclipse.core.resource.events.ResourceStatesChangedEvent;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;

public class FilterManager
implements IPropertyChangeListener,
IResourceStatesListener {
    private static FilterManager instance = null;
    protected Map filters2condition = new HashMap();
    protected Map recursiveFilters2condition = new HashMap();
    protected MapChecker flatChecker = new MapChecker(this.filters2condition);
    protected MapChecker recursiveChecker = new MapChecker(this.recursiveFilters2condition);
    protected boolean dirty;

    public static synchronized FilterManager instance() {
        if (instance == null) {
            instance = new FilterManager();
        }
        return instance;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(ModelBusTeamPreferences.fullDecorationName("precise.enablements")) || event.getProperty().equals(ModelBusTeamPreferences.fullCoreName("modelbusconnector"))) {
            this.clear();
        }
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        this.clear();
    }

    public void clear() {
        this.dirty = true;
    }

    public boolean checkForResourcesPresenceRecursive(IResource[] selectedResources, IStateFilter stateFilter) {
        return this.checkForResourcesPresence(selectedResources, stateFilter, true);
    }

    public boolean checkForResourcesPresence(IResource[] selectedResources, IStateFilter stateFilter, boolean recursive) {
        Map filtersMap;
        Boolean retVal;
        boolean computeDeep = ModelBusTeamPreferences.getDecorationBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "precise.enablements");
        if (this.dirty) {
            this.dirty = false;
            if (!this.connectedToModelBus(selectedResources)) {
                this.flatChecker.clearFilters();
                this.flatChecker.checkDisallowed();
                this.recursiveChecker.clearFilters();
                this.recursiveChecker.checkDisallowed();
                return false;
            }
            if (this.filters2condition.size() > 0) {
                this.flatChecker.clearFilters();
                FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)this.flatChecker, (int)0);
                this.flatChecker.checkDisallowed();
            }
            if (computeDeep) {
                if (this.recursiveFilters2condition.size() > 0) {
                    this.recursiveChecker.clearFilters();
                    FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)this.recursiveChecker, (int)2);
                    this.recursiveChecker.checkDisallowed();
                }
            } else {
                this.recursiveChecker.setAllTo(Boolean.TRUE);
            }
        }
        if ((retVal = (Boolean)(filtersMap = recursive ? this.recursiveFilters2condition : this.filters2condition).get(stateFilter)) == null) {
            if (!computeDeep && recursive) {
                retVal = Boolean.TRUE;
                filtersMap.put(stateFilter, retVal);
            } else {
                boolean containsResources = FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)stateFilter, (int)(recursive ? 2 : 0));
                retVal = containsResources;
                filtersMap.put(stateFilter, retVal);
            }
        }
        return retVal;
    }

    protected boolean connectedToModelBus(IResource[] selectedResources) {
        int i = 0;
        while (i < selectedResources.length) {
            if (!FileUtility.isConnected((IResource)selectedResources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private FilterManager() {
        ModelBusTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        ModelBusRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
    }

    protected static class MapChecker
    extends IStateFilter.AbstractStateFilter {
        protected Map filterMap;

        public MapChecker(Map filterMap) {
            this.filterMap = filterMap;
        }

        public void clearFilters() {
            Iterator it = this.filterMap.keySet().iterator();
            while (it.hasNext()) {
                this.filterMap.put(it.next(), null);
            }
        }

        public void setAllTo(Boolean value) {
            Iterator it = this.filterMap.keySet().iterator();
            while (it.hasNext()) {
                this.filterMap.put(it.next(), value);
            }
        }

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            boolean retVal = true;
            for (Map.Entry entry : this.filterMap.entrySet()) {
                if (entry.getValue() != null) continue;
                IStateFilter filter = (IStateFilter)entry.getKey();
                boolean value = local == null ? filter.accept(resource, state, mask) : filter.accept(local);
                retVal &= value;
                if (!value) continue;
                this.filterMap.put(filter, Boolean.TRUE);
            }
            return retVal;
        }

        public void checkDisallowed() {
            for (Map.Entry entry : this.filterMap.entrySet()) {
                if (entry.getValue() != null) continue;
                this.filterMap.put(entry.getKey(), Boolean.FALSE);
            }
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    }
}

