/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.AddToModelBusIgnoreOperation;
import org.modelbus.team.eclipse.core.operation.local.AddToModelBusOperation;
import org.modelbus.team.eclipse.core.operation.local.ClearLocalStatusesOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.ui.action.AbstractNonRecursiveTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.AbstractDialogPanel;
import org.modelbus.team.eclipse.ui.panel.local.AbstractResourceSelectionPanel;
import org.modelbus.team.eclipse.ui.panel.local.AddToModelBusPanel;
import org.modelbus.team.eclipse.ui.panel.local.IgnoreMethodPanel;

public class AddToModelBusIgnoreAction
extends AbstractNonRecursiveTeamAction {
    public static IStateFilter SF_NEW_AND_PARENT_VERSIONED = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            IContainer parent;
            if (state == "New" && (parent = resource.getParent()) != null) {
                return IStateFilter.SF_VERSIONED.accept(ModelBusRemoteStorage.instance().asLocalResource((IResource)parent));
            }
            return false;
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return state != "Ignored" && state != "Obstructed" && state != "Linked";
        }
    };

    @Override
    public void runImpl(IAction action) {
        AbstractDialogPanel panel;
        IResource[] resources = this.getSelectedResources(SF_NEW_AND_PARENT_VERSIONED);
        IResource[] operableParents = FileUtility.getOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_UNVERSIONED);
        if (operableParents.length > 0) {
            panel = new AddToModelBusPanel(operableParents);
            DefaultDialog dialog1 = new DefaultDialog(this.getShell(), panel);
            if (dialog1.open() != 0) {
                return;
            }
            operableParents = ((AbstractResourceSelectionPanel)panel).getSelectedResources();
        }
        panel = new IgnoreMethodPanel(resources);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            AddToModelBusIgnoreOperation mainOp = new AddToModelBusIgnoreOperation(resources, ((IgnoreMethodPanel)panel).getIgnoreType(), ((IgnoreMethodPanel)panel).getIgnorePattern());
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            if (operableParents.length > 0) {
                op.add((IActionOperation)new AddToModelBusOperation(operableParents));
                op.add((IActionOperation)new ClearLocalStatusesOperation(operableParents));
            }
            op.add((IActionOperation)mainOp);
            HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources));
            int i = 0;
            while (i < resources.length) {
                tmp.add((IResource)resources[i].getParent());
                ++i;
            }
            IResource[] resourcesAndParents = tmp.toArray(new IResource[tmp.size()]);
            op.add((IActionOperation)new RefreshResourcesOperation(resourcesAndParents, 2, RefreshResourcesOperation.REFRESH_ALL));
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(SF_NEW_AND_PARENT_VERSIONED);
    }
}

