/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.action.AbstractRecursiveTeamAction;
import org.modelbus.team.eclipse.ui.dialog.TagModifyWarningDialog;
import org.modelbus.team.eclipse.ui.extension.ExtensionsManager;
import org.modelbus.team.eclipse.ui.extension.factory.ICommitDialog;
import org.modelbus.team.eclipse.ui.panel.local.CommitPanel;
import org.modelbus.team.eclipse.ui.synchronize.ModelBusChangeSetCapability;
import org.modelbus.team.eclipse.ui.utility.CommitActionUtility;

public class CommitAction
extends AbstractRecursiveTeamAction {
    public static final IStateFilter SF_ANY_CHANGE = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return IStateFilter.SF_ANY_CHANGE.accept(resource, state, mask) && state != "Conflicting";
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    @Override
    public void runImpl(IAction action) {
        TagModifyWarningDialog dlg;
        CommitActionUtility commitUtility = new CommitActionUtility(this);
        IResource[] allResources = commitUtility.getAllResources();
        if (ModelBusUtility.isTagOperated((IResource[])allResources) && (dlg = new TagModifyWarningDialog(this.getShell())).open() != 0) {
            return;
        }
        String proposedComment = ModelBusChangeSetCapability.getProposedComment(commitUtility.getAllResources());
        CommitPanel commitPanel = new CommitPanel(allResources, this.getSelectedResources(), 0, proposedComment);
        ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(this.getShell(), commitUtility.getAllResourcesSet(), commitPanel);
        if (commitDialog.open() == 0) {
            if (commitPanel.getResourcesChanged()) {
                commitUtility.initialize(this);
            }
            CompositeOperation op = commitUtility.getCompositeCommitOperation(commitPanel.getSelectedResources(), commitPanel.getNotSelectedResources(), commitDialog.getMessage(), commitPanel.getKeepLocks(), this.getShell(), this.getTargetPart(), true);
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresenceRecursive(SF_ANY_CHANGE);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

