/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.RepositoryProvider;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRepositoryFile;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRepositoryFolder;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractWorkingCopyAction;
import org.modelbus.team.eclipse.ui.compare.ModelBusCompareEditorInput;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.panel.remote.CompareBranchTagPanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;

public class CompareWithBranchTagAction
extends AbstractWorkingCopyAction {
    protected int type;

    public CompareWithBranchTagAction(int type) {
        this.type = type;
    }

    @Override
    public boolean isEnabled() {
        if (this.getSelectedResources().length == 1) {
            boolean isCompareFoldersAllowed = true;
            boolean recommendedLayoutUsed = ModelBusTeamPreferences.getRepositoryBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.getSelectedResources()[0].getProject(), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
            boolean isModelBusRepositoryProvider = provider instanceof ModelBusRepositoryProvider;
            return (isCompareFoldersAllowed || this.getSelectedResources()[0].getType() == 1) && recommendedLayoutUsed && isModelBusRepositoryProvider;
        }
        return false;
    }

    @Override
    public void runImpl(IAction action) {
        IResource resource = this.getSelectedResources()[0];
        ModelBusRepositoryFile remote = null;
        String remotePath = null;
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.modelbus.team.eclipse.repository.ModelBusRepositoryProvider");
        if (provider instanceof ModelBusRepositoryProvider) {
            remotePath = ((ModelBusRepositoryProvider)provider).getRepositoryPath(resource);
            if (resource.getType() == 1) {
                remote = new ModelBusRepositoryFile(remotePath, ModelBusRevision.HEAD);
            } else if (resource.getType() == 2) {
                remote = new ModelBusRepositoryFolder(remotePath, ModelBusRevision.HEAD);
            }
        }
        CompareBranchTagPanel panel = new CompareBranchTagPanel((IRepositoryResource)remote, this.type);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            remote = panel.getSelectedResoure();
            ModelBusRevision revision = remote.getSelectedRevision();
            CompareConfiguration configuration = new CompareConfiguration();
            configuration.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
            String revisionString = "-1";
            if (revision instanceof ModelBusRevision.StringRevision) {
                revisionString = ((ModelBusRevision.StringRevision)revision).getRevision();
            }
            ModelBusCompareEditorInput compare = new ModelBusCompareEditorInput(configuration, provider, resource, revisionString);
            CompareUI.openCompareEditor((CompareEditorInput)compare);
        }
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

