/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.modelbusstorage.ResourcesParentsProvider;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.JavaHLMergeOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResourceProvider;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractNonRecursiveTeamAction;
import org.modelbus.team.eclipse.ui.dialog.AdvancedDialog;
import org.modelbus.team.eclipse.ui.dialog.OperationErrorDialog;
import org.modelbus.team.eclipse.ui.operation.ShowMergeViewOperation;
import org.modelbus.team.eclipse.ui.panel.local.MergePanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;

public class MergeAction
extends AbstractNonRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, ModelBusTeamUIPlugin.instance().getResource("MergeAction.MergeError"), this.getShell())) {
            return;
        }
        IRepositoryResource remote = ModelBusRemoteStorage.instance().asRepositoryResource(resources[0]);
        ModelBusRevision revision = ModelBusRemoteStorage.instance().asLocalResourceAccessible(resources[0]).getRevision();
        if (resources.length > 1) {
            revision = ModelBusRevision.INVALID_REVISION_DESCRIPTOR;
            remote = remote.getRoot();
        }
        MergePanel panel = new MergePanel(resources, remote, revision);
        AdvancedDialog dialog = new AdvancedDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            LocateResourceURLInHistoryOperation locateFirst = new LocateResourceURLInHistoryOperation(panel.getFirstSelection());
            LocateResourceURLInHistoryOperation locateSecond = null;
            LocateResourceURLInHistoryOperation firstSet = locateFirst;
            LocateResourceURLInHistoryOperation secondSet = null;
            if (panel.getMode() == 0) {
                firstSet = new IRepositoryResourceProvider.DefaultRepositoryResourceProvider(panel.getFirstSelection());
            } else if (panel.getMode() == 1) {
                secondSet = locateSecond = new LocateResourceURLInHistoryOperation(panel.getSecondSelection());
            }
            ShowMergeViewOperation mergeOp = null;
            if (ModelBusTeamPreferences.getMergeBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "useJavaHL")) {
                JavaHLMergeOperation mainOp = null;
                mainOp = panel.getMode() == 1 ? new JavaHLMergeOperation(resources, (IRepositoryResourceProvider)firstSet, (IRepositoryResourceProvider)secondSet, false, panel.getIgnoreAncestry(), panel.getDepth()) : (panel.getMode() == 0 ? new JavaHLMergeOperation(resources, (IRepositoryResourceProvider)firstSet, panel.getSelectedRevisions(), false, panel.getIgnoreAncestry(), panel.getDepth()) : new JavaHLMergeOperation(resources, (IRepositoryResourceProvider)firstSet, false));
                CompositeOperation op = new CompositeOperation(mainOp.getId());
                SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
                op.add((IActionOperation)saveOp);
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(resources)));
                mergeOp = op;
            } else {
                mergeOp = panel.getMode() == 1 ? new ShowMergeViewOperation(resources, (IRepositoryResourceProvider)firstSet, (IRepositoryResourceProvider)secondSet, panel.getIgnoreAncestry(), panel.getDepth(), this.getTargetPart()) : (panel.getMode() == 0 ? new ShowMergeViewOperation(resources, (IRepositoryResourceProvider)firstSet, panel.getSelectedRevisions(), panel.getIgnoreAncestry(), panel.getDepth(), this.getTargetPart()) : new ShowMergeViewOperation(resources, (IRepositoryResourceProvider)firstSet, this.getTargetPart()));
            }
            if (panel.getMode() != 0) {
                CompositeOperation op = new CompositeOperation(mergeOp.getId());
                op.add((IActionOperation)locateFirst);
                if (panel.getMode() == 1) {
                    op.add((IActionOperation)locateSecond);
                }
                op.add((IActionOperation)mergeOp);
                this.runScheduled((IActionOperation)op);
            } else {
                this.runScheduled((IActionOperation)mergeOp);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

