/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.GetRemoteContentsOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.utility.FileUtility;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.action.AbstractNonRecursiveTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.dialog.ReplaceWarningDialog;
import org.modelbus.team.eclipse.ui.panel.local.ReplaceWithUrlPanel;

public class ReplaceWithRevisionAction
extends AbstractNonRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_ONREPOSITORY);
        IActionOperation op = ReplaceWithRevisionAction.getReplaceOperation(resources, this.getShell());
        if (op != null) {
            this.runScheduled(op);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    public static IActionOperation getReplaceOperation(IResource[] resources, Shell shell) {
        ReplaceWarningDialog dialog;
        ILocalResource local;
        IRepositoryResource remote = ModelBusRemoteStorage.instance().asRepositoryResource(resources[0]);
        ReplaceWithUrlPanel panel = new ReplaceWithUrlPanel(remote, (local = ModelBusRemoteStorage.instance().asLocalResourceAccessible(resources[0])).getRevision());
        DefaultDialog selectionDialog = new DefaultDialog(shell, panel);
        if (selectionDialog.open() == 0 && (dialog = new ReplaceWarningDialog(shell)).open() == 0) {
            IRepositoryResource selected = panel.getSelectedResource();
            HashMap<String, String> remote2local = new HashMap<String, String>();
            remote2local.put(ModelBusUtility.encodeURL((String)selected.getUrl()), FileUtility.getWorkingCopyPath((IResource)resources[0]));
            CompositeOperation op = new CompositeOperation("Operation.ReplaceWithRevision");
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)new GetRemoteContentsOperation(resources, new IRepositoryResource[]{selected}, remote2local));
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            return op;
        }
        return null;
    }
}

