/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.connector.ModelBusRevision;
import org.modelbus.team.eclipse.core.modelbusstorage.ModelBusRemoteStorage;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SwitchOperation;
import org.modelbus.team.eclipse.core.resource.ILocalResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractNonRecursiveTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.dialog.OperationErrorDialog;
import org.modelbus.team.eclipse.ui.panel.local.SwitchPanel;

public class SwitchAction
extends AbstractNonRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        SwitchPanel panel;
        IRepositoryResource remote;
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, ModelBusTeamUIPlugin.instance().getResource("SwitchAction.Error"), this.getShell())) {
            return;
        }
        if (resources.length > 1) {
            boolean containFolders = false;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource current = iResourceArray[n2];
                if (current instanceof IContainer) {
                    containFolders = true;
                    break;
                }
                ++n2;
            }
            remote = ModelBusRemoteStorage.instance().asRepositoryResource(resources[0]);
            System.out.println("CHECKMWA36");
            panel = new SwitchPanel(remote, ModelBusRevision.INVALID_REVISION_DESCRIPTOR, containFolders);
        } else {
            IResource resource = resources[0];
            remote = ModelBusRemoteStorage.instance().asRepositoryResource(resource);
            ILocalResource local = ModelBusRemoteStorage.instance().asLocalResourceAccessible(resource);
            panel = new SwitchPanel(remote, local.getRevision(), resources[0] instanceof IContainer);
        }
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            IRepositoryResource[] destinations = panel.getSelection(resources);
            SwitchOperation mainOp = new SwitchOperation(resources, destinations, panel.getDepth());
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

