/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.modelbusstorage.ResourcesParentsProvider;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.IUnresolvedConflictDetector;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.RestoreProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.SaveProjectMetaOperation;
import org.modelbus.team.eclipse.core.operation.local.UpdateOperation;
import org.modelbus.team.eclipse.core.resource.IResourceProvider;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRecursiveTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.ClearUpdateStatusesOperation;
import org.modelbus.team.eclipse.ui.operation.NotifyUnresolvedConflictOperation;
import org.modelbus.team.eclipse.ui.panel.local.ResourceListPanel;
import org.modelbus.team.eclipse.ui.utility.UnacceptableOperationNotificator;

public class UpdateAction
extends AbstractRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        IResource[] missing;
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(this.getShell(), this.getSelectedResources(IStateFilter.SF_ONREPOSITORY));
        if (resources == null || resources.length == 0) {
            return;
        }
        if (this.checkForResourcesPresenceRecursive(IStateFilter.SF_REVERTABLE) && (missing = this.getSelectedResourcesRecursive(IStateFilter.SF_MISSING)).length > 0 && !UpdateAction.updateMissing(this.getShell(), missing)) {
            return;
        }
        this.runScheduled((IActionOperation)UpdateAction.getUpdateOperation(resources));
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    public static boolean updateMissing(Shell shell, IResource[] missing) {
        ResourceListPanel panel = new ResourceListPanel(missing, ModelBusTeamUIPlugin.instance().getResource("UpdateAction.List.Title"), ModelBusTeamUIPlugin.instance().getResource("UpdateAction.List.Description"), ModelBusTeamUIPlugin.instance().getResource("UpdateAction.List.Message"), new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
        panel.setShowLocalNames(true);
        return new DefaultDialog(shell, panel).open() == 0;
    }

    public static CompositeOperation getUpdateOperation(IResource[] updateSet) {
        UpdateOperation mainOp = new UpdateOperation(updateSet, true);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(updateSet);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp));
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((IResourceProvider)mainOp)));
        op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        return op;
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

