/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.local.management;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.IStateFilter;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.local.NotifyProjectStatesChangedOperation;
import org.modelbus.team.eclipse.core.operation.local.RefreshResourcesOperation;
import org.modelbus.team.eclipse.core.operation.local.management.DisconnectOperation;
import org.modelbus.team.eclipse.ui.action.AbstractLocalTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DisconnectDialog;

public class DisconnectAction
extends AbstractLocalTeamAction {
    protected static final int OP_CANCEL = 0;
    protected static final int OP_DROP = 1;
    protected static final int OP_LEAVE = 2;

    @Override
    public void runImpl(IAction action) {
        int opType = this.selectOperationType();
        if (opType != 0) {
            IProject[] projects = this.getSelectedProjects();
            DisconnectOperation mainOp = new DisconnectOperation(projects, opType == 1);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)new NotifyProjectStatesChangedOperation(projects, 3));
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation((IResource[])projects, 2, RefreshResourcesOperation.REFRESH_ALL));
            op.add((IActionOperation)new NotifyProjectStatesChangedOperation(projects, 1));
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    protected int selectOperationType() {
        DisconnectDialog dialog = new DisconnectDialog(this.getShell(), this.getSelectedProjects());
        if (dialog.open() == 0) {
            return dialog.dropModelBusFolders() ? 1 : 2;
        }
        return 0;
    }
}

