/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.IRevisionProvider;
import org.modelbus.team.eclipse.core.operation.remote.AbstractCopyMoveResourcesOperation;
import org.modelbus.team.eclipse.core.operation.remote.SetRevisionAuthorNameOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.wizard.copymove.CopyMoveWizard;

public abstract class AbstractCopyMoveAction
extends AbstractRepositoryTeamAction {
    protected String operationId;

    public AbstractCopyMoveAction(String operationId) {
        this.operationId = operationId;
    }

    @Override
    public void runImpl(IAction action) {
        CopyMoveWizard copyMoveWizard = new CopyMoveWizard(this.getSelectedRepositoryResources(), this.operationId.toLowerCase().contains("move"));
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)copyMoveWizard);
        if (dlg.open() == 0) {
            String message = copyMoveWizard.getComment();
            IRepositoryResource[] selected = this.getSelectedRepositoryResources();
            IRepositoryResource destination = copyMoveWizard.getDestination();
            AbstractCopyMoveResourcesOperation moveOp = this.makeCopyOperation(destination, selected, message, copyMoveWizard.getNewName());
            CompositeOperation op = new CompositeOperation(moveOp.getId());
            op.add((IActionOperation)moveOp);
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)moveOp, 4L));
            op.add((IActionOperation)this.makeRefreshOperation(destination, selected));
            this.runScheduled((IActionOperation)op);
        }
    }

    protected abstract AbstractCopyMoveResourcesOperation makeCopyOperation(IRepositoryResource var1, IRepositoryResource[] var2, String var3, String var4);

    protected abstract RefreshRemoteResourcesOperation makeRefreshOperation(IRepositoryResource var1, IRepositoryResource[] var2);
}

