/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorException;
import org.modelbus.team.eclipse.core.operation.CompositeOperation;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.operation.remote.PreparedBranchTagOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryContainer;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.core.resource.IRepositoryRoot;
import org.modelbus.team.eclipse.core.utility.ModelBusUtility;
import org.modelbus.team.eclipse.ui.ModelBusTeamUIPlugin;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.dialog.OperationErrorDialog;
import org.modelbus.team.eclipse.ui.operation.GetRemoteFolderChildrenOperation;
import org.modelbus.team.eclipse.ui.operation.RefreshRemoteResourcesOperation;
import org.modelbus.team.eclipse.ui.panel.common.AbstractBranchTagPanel;
import org.modelbus.team.eclipse.ui.panel.common.BranchPanel;
import org.modelbus.team.eclipse.ui.panel.common.TagPanel;
import org.modelbus.team.eclipse.ui.preferences.ModelBusTeamPreferences;
import org.modelbus.team.eclipse.ui.utility.DefaultOperationWrapperFactory;
import org.modelbus.team.eclipse.ui.utility.UIMonitorUtility;

public class BranchTagAction
extends AbstractRepositoryTeamAction {
    public static final int BRANCH_ACTION = 0;
    public static final int TAG_ACTION = 1;
    protected int nodeType;

    public BranchTagAction(int nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(resources, this.getShell(), this.nodeType);
        if (op != null) {
            CompositeOperation composite = new CompositeOperation(op.getId());
            composite.add((IActionOperation)op);
            composite.add((IActionOperation)new RefreshRemoteResourcesOperation(new IRepositoryResource[]{op.getDestination().getParent()}), new IActionOperation[]{op});
            this.runScheduled((IActionOperation)composite);
        }
    }

    public static PreparedBranchTagOperation getBranchTagOperation(IRepositoryResource[] resources, Shell shell, int nodeType) {
        AbstractBranchTagPanel panel;
        DefaultDialog dialog;
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, ModelBusTeamUIPlugin.instance().getResource(nodeType == 0 ? "BranchTagAction.Error.Branch" : "BranchTagAction.Error.Tag"), shell)) {
            return null;
        }
        resources = ModelBusUtility.shrinkChildNodes((IRepositoryResource[])resources);
        boolean isStructureEnabled = ModelBusTeamPreferences.getRepositoryBoolean(ModelBusTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        Set<Object> nodeNames = Collections.emptySet();
        boolean forceCreate = false;
        if (isStructureEnabled) {
            int kind = ((IRepositoryRoot)resources[0].getRoot()).getKind();
            if (kind == 0 || kind == 4) {
                try {
                    IRepositoryContainer supposedTrunk = resources[0].asRepositoryContainer("trunk", false);
                    if (supposedTrunk.exists()) {
                        resources[0] = supposedTrunk;
                    }
                }
                catch (ModelBusConnectorException modelBusConnectorException) {}
            }
            nodeNames = BranchTagAction.getExistingNodeNames((IRepositoryContainer)(nodeType == 0 ? ModelBusUtility.getBranchesLocation((IRepositoryResource)resources[0]) : ModelBusUtility.getTagsLocation((IRepositoryResource)resources[0])));
            forceCreate = resources.length == 1 && (!(resources[0] instanceof IRepositoryRoot) || ((IRepositoryRoot)resources[0]).getKind() != 1) && !BranchTagAction.isSingleProjectLayout(resources[0]) && BranchTagAction.isProjectFileExists(resources[0]);
        }
        if ((dialog = new DefaultDialog(shell, panel = nodeType == 0 ? new BranchPanel(ModelBusUtility.getBranchesLocation((IRepositoryResource)resources[0]), false, nodeNames, resources) : new TagPanel(ModelBusUtility.getTagsLocation((IRepositoryResource)resources[0]), false, nodeNames, resources))).open() == 0) {
            IRepositoryResource[] resourcesWithSpecifiedRevision = new IRepositoryResource[resources.length];
            int i = 0;
            while (i < resources.length) {
                resourcesWithSpecifiedRevision[i] = ModelBusUtility.copyOf((IRepositoryResource)resources[i]);
                resourcesWithSpecifiedRevision[i].setSelectedRevision(panel.getRevisionForRemoteResources());
                resourcesWithSpecifiedRevision[i].setPegRevision(resources[i].getPegRevision());
                ++i;
            }
            return new PreparedBranchTagOperation(nodeType == 0 ? "Branch" : "Tag", resourcesWithSpecifiedRevision, panel.getDestination(), panel.getMessage(), forceCreate);
        }
        return null;
    }

    public static Set<String> getExistingNodeNames(IRepositoryContainer parent) {
        HashSet<String> nodeNames = new HashSet<String>();
        IRepositoryResource[] existentNodes = BranchTagAction.getRemoteChildren(parent);
        if (existentNodes != null) {
            int i = 0;
            while (i < existentNodes.length) {
                nodeNames.add(existentNodes[i].getName());
                ++i;
            }
        }
        return nodeNames;
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        return resources.length != 0;
    }

    protected static IRepositoryResource[] getRemoteChildren(IRepositoryContainer parent) {
        GetRemoteFolderChildrenOperation op = new GetRemoteFolderChildrenOperation(parent, false);
        UIMonitorUtility.doTaskBusy((IActionOperation)op, new DefaultOperationWrapperFactory(){

            @Override
            public IActionOperation getLogged(IActionOperation operation) {
                return operation;
            }
        });
        return op.getChildren();
    }

    public static boolean isSingleProjectLayout(IRepositoryResource resource) {
        System.out.println("TODOMWA28");
        return true;
    }

    protected static boolean isProjectFileExists(IRepositoryResource resource) {
        try {
            return resource.asRepositoryFile(".project", false).exists();
        }
        catch (ModelBusConnectorException modelBusConnectorException) {
            return false;
        }
    }
}

