/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.team.eclipse.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.modelbus.team.eclipse.core.connector.ModelBusConnectorException;
import org.modelbus.team.eclipse.core.operation.IActionOperation;
import org.modelbus.team.eclipse.core.resource.IRepositoryResource;
import org.modelbus.team.eclipse.ui.action.AbstractRepositoryTeamAction;
import org.modelbus.team.eclipse.ui.dialog.DefaultDialog;
import org.modelbus.team.eclipse.ui.operation.CompareRepositoryResourcesOperation;
import org.modelbus.team.eclipse.ui.operation.UILoggedOperation;
import org.modelbus.team.eclipse.ui.panel.remote.ComparePanel;

public class CompareAction
extends AbstractRepositoryTeamAction {
    @Override
    public void runImpl(IAction action) {
        IRepositoryResource first = this.getSelectedRepositoryResources()[0];
        ComparePanel panel = new ComparePanel(first);
        panel.setFilterCurrent(true);
        DefaultDialog dlg = new DefaultDialog(this.getShell(), panel);
        if (dlg.open() == 0) {
            this.doCompare(first, panel.getSelectedResource());
        }
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    protected void doCompare(IRepositoryResource first, IRepositoryResource second) {
        try {
            if (second.getRevision().isGreaterThan(first.getRevision())) {
                IRepositoryResource tmp = second;
                second = first;
                first = tmp;
            }
        }
        catch (ModelBusConnectorException ex) {
            UILoggedOperation.reportError("Compare", ex);
        }
        this.runScheduled((IActionOperation)new CompareRepositoryResourcesOperation(second, first));
    }
}

